/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.fluid;

import liedge.limacore.capability.fluid.LimaFluidTank;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.ApiStatus;

public class VariableFluidTank
implements LimaFluidTank {
    private FluidStack fluid;
    private int capacity;
    private int transferRate;

    public VariableFluidTank(FluidStack fluid, int capacity, int transferRate) {
        this.fluid = fluid;
        this.capacity = capacity;
        this.transferRate = transferRate;
    }

    public VariableFluidTank(int capacity, int transferRate) {
        this(FluidStack.EMPTY, capacity, transferRate);
    }

    public LimaDataWatcher<FluidStack> syncFluid() {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.FLUID_STACK, () -> this.fluid.copy(), this::setFluid);
    }

    public LimaDataWatcher<Integer> syncCapacity() {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.VAR_INT, this::getCapacity, this::setCapacity);
    }

    public LimaDataWatcher<Integer> syncTransferRate() {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.VAR_INT, this::getTransferRate, this::setTransferRate);
    }

    public void syncTank(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(this.syncFluid());
        collector.register(this.syncCapacity());
        collector.register(this.syncTransferRate());
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public LimaFluidTank copy() {
        return new VariableFluidTank(this.fluid.copy(), this.capacity, this.transferRate);
    }

    @Override
    @ApiStatus.Internal
    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        if (resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource) && !this.fluid.isEmpty()) {
            return 0;
        }
        int limit = ignoreLimit ? Integer.MAX_VALUE : this.transferRate;
        int stored = this.fluid.getAmount();
        int actuallyReceived = Math.min(this.capacity - stored, Math.min(resource.getAmount(), limit));
        if (action.simulate()) {
            return actuallyReceived;
        }
        if (this.fluid.isEmpty()) {
            this.fluid = resource.copyWithAmount(actuallyReceived);
        } else {
            this.fluid.grow(actuallyReceived);
        }
        return actuallyReceived;
    }

    @Override
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        if (maxDrain <= 0 || this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int limit = ignoreLimit ? Integer.MAX_VALUE : this.transferRate;
        int stored = this.fluid.getAmount();
        int actuallyDrained = Math.min(stored, Math.min(maxDrain, limit));
        FluidStack result = this.fluid.copyWithAmount(actuallyDrained);
        if (!action.simulate() && actuallyDrained > 0) {
            this.fluid.shrink(actuallyDrained);
        }
        return result;
    }

    @Override
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        return !resource.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource) ? this.drain(resource.getAmount(), action, ignoreLimit) : FluidStack.EMPTY;
    }
}

