/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.itemhandler;

import liedge.limacore.blockentity.IOAccess;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public interface ItemHandlerIOWrapper
extends IItemHandlerModifiable {
    public static ItemHandlerIOWrapper of(IItemHandlerModifiable handler, IOAccess access) {
        return new SimpleWrapper(handler, access);
    }

    public IItemHandlerModifiable itemHandler();

    public boolean allowInput(int var1);

    public boolean allowOutput(int var1);

    default public int getSlots() {
        return this.itemHandler().getSlots();
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        this.itemHandler().setStackInSlot(slot, stack);
    }

    default public ItemStack getStackInSlot(int slot) {
        return this.itemHandler().getStackInSlot(slot);
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.allowInput(slot)) {
            return this.itemHandler().insertItem(slot, stack, simulate);
        }
        return stack;
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.allowOutput(slot)) {
            return this.itemHandler().extractItem(slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    default public int getSlotLimit(int slot) {
        return this.itemHandler().getSlotLimit(slot);
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        return this.itemHandler().isItemValid(slot, stack);
    }

    public record SimpleWrapper(IItemHandlerModifiable itemHandler, IOAccess access) implements ItemHandlerIOWrapper
    {
        @Override
        public boolean allowInput(int slot) {
            return this.access.allowsInput();
        }

        @Override
        public boolean allowOutput(int slot) {
            return this.access.allowsOutput();
        }
    }
}

