/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.itemhandler;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.capability.itemhandler.ItemHandlerIOWrapper;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.capability.itemhandler.LimaItemHandler;
import liedge.limacore.util.LimaNbtUtil;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.ItemStackHandler;

public class LimaBlockEntityItemHandler
extends ItemStackHandler
implements LimaItemHandler {
    private final ItemHolderBlockEntity blockEntity;
    private final BlockContentsType contentsType;

    public LimaBlockEntityItemHandler(ItemHolderBlockEntity blockEntity, int size, BlockContentsType contentsType) {
        super(size);
        this.blockEntity = blockEntity;
        this.contentsType = contentsType;
    }

    public ItemHandlerIOWrapper createIOWrapper(IOAccess blockAccessLevel) {
        return new IOWrapper(this, blockAccessLevel);
    }

    public ItemStackHandler copyHandler() {
        NonNullList copiedStacks = this.stacks.stream().map(ItemStack::copy).collect(LimaStreamsUtil.toNonNullList());
        return new ItemStackHandler(copiedStacks);
    }

    @Deprecated
    public void setSize(int size) {
        super.setSize(size);
    }

    public List<ItemStack> resizeInventory(int newSize) {
        Preconditions.checkArgument((newSize > 0 ? 1 : 0) != 0, (Object)"Inventory size must be greater than 0.");
        int currentSize = this.stacks.size();
        if (newSize == currentSize) {
            return List.of();
        }
        if (newSize > currentSize) {
            NonNullList newStacks = NonNullList.withSize((int)newSize, (Object)ItemStack.EMPTY);
            for (int i = 0; i < currentSize; ++i) {
                newStacks.set(i, (Object)((ItemStack)this.stacks.get(i)));
            }
            this.stacks = newStacks;
            return List.of();
        }
        NonNullList newStacks = NonNullList.withSize((int)newSize, (Object)ItemStack.EMPTY);
        ObjectArrayList remainingStacks = new ObjectArrayList();
        for (int i = 0; i < currentSize; ++i) {
            ItemStack current = (ItemStack)this.stacks.get(i);
            if (i < newSize) {
                newStacks.set(i, (Object)current);
                continue;
            }
            if (current.isEmpty()) continue;
            remainingStacks.add(current.copy());
        }
        this.stacks = newStacks;
        return remainingStacks;
    }

    @Override
    public ItemContainerContents copyToComponent() {
        return ItemContainerContents.fromItems((List)this.stacks);
    }

    @Override
    public void copyFromComponent(ItemContainerContents contents) {
        for (int i = 0; i < contents.getSlots(); ++i) {
            ItemStack toSet;
            if (i >= this.stacks.size() || !this.isItemValid(i, toSet = contents.getStackInSlot(i))) continue;
            this.setStackInSlot(i, toSet);
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.blockEntity.isItemValid(this.contentsType, slot, stack);
    }

    @Override
    public void onContentsChanged(int slot) {
        this.blockEntity.onItemSlotChanged(this.contentsType, slot);
    }

    protected void onLoad() {
        this.blockEntity.onItemHandlerLoaded(this.contentsType);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        int size = Math.max(this.stacks.size(), LimaNbtUtil.getAsInt(nbt, "Size", -1));
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        ListTag listTag = nbt.getList("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag stackTag = listTag.getCompound(i);
            int slot = stackTag.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack.parse((HolderLookup.Provider)provider, (Tag)stackTag).ifPresent(stack -> this.stacks.set(slot, stack));
        }
        this.onLoad();
    }

    private static final class IOWrapper
    extends Record
    implements ItemHandlerIOWrapper {
        private final LimaBlockEntityItemHandler itemHandler;
        private final IOAccess blockAccessLevel;

        private IOWrapper(LimaBlockEntityItemHandler itemHandler, IOAccess blockAccessLevel) {
            this.itemHandler = itemHandler;
            this.blockAccessLevel = blockAccessLevel;
        }

        @Override
        public boolean allowInput(int slot) {
            return this.blockAccessLevel.allowsInput() && this.itemHandler.blockEntity.getItemHandlerSlotIO(this.itemHandler.contentsType, slot).allowsInput();
        }

        @Override
        public boolean allowOutput(int slot) {
            return this.blockAccessLevel.allowsOutput() && this.itemHandler.blockEntity.getItemHandlerSlotIO(this.itemHandler.contentsType, slot).allowsOutput();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IOWrapper.class, "itemHandler;blockAccessLevel", "itemHandler", "blockAccessLevel"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IOWrapper.class, "itemHandler;blockAccessLevel", "itemHandler", "blockAccessLevel"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IOWrapper.class, "itemHandler;blockAccessLevel", "itemHandler", "blockAccessLevel"}, this, o);
        }

        @Override
        public LimaBlockEntityItemHandler itemHandler() {
            return this.itemHandler;
        }

        public IOAccess blockAccessLevel() {
            return this.blockAccessLevel;
        }
    }
}

