/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.itemhandler;

import java.util.function.Predicate;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.util.LimaItemUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;

public final class LimaItemHandlerUtil {
    private LimaItemHandlerUtil() {
    }

    public static RangedWrapper sizedRangedWrapper(IItemHandlerModifiable source, int startSlot, int slotCount) {
        return new RangedWrapper(source, startSlot, startSlot + slotCount);
    }

    public static int getNextEmptySlot(IItemHandler handler, boolean reverse) {
        int step;
        int i = reverse ? handler.getSlots() - 1 : 0;
        int n = step = reverse ? -1 : 1;
        while (reverse ? i >= 0 : i < handler.getSlots()) {
            if (handler.getStackInSlot(i).isEmpty()) {
                return i;
            }
            i += step;
        }
        return -1;
    }

    public static int getNextEmptySlot(IItemHandler handler) {
        return LimaItemHandlerUtil.getNextEmptySlot(handler, false);
    }

    public static ItemStack extractFromAnySlot(IItemHandler source, int amount, boolean simulate) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack existingStack = source.getStackInSlot(i);
            if (existingStack.isEmpty()) continue;
            return source.extractItem(i, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack insertItemIntoSlots(IItemHandler destination, ItemStack toInsert, int slotStartInclusive, int slotEndExclusive, boolean simulate) {
        LimaCoreMath.validateOpenIndexRange(slotStartInclusive, slotEndExclusive, destination.getSlots());
        if (toInsert.isEmpty()) {
            return toInsert;
        }
        for (int i = slotStartInclusive; i < slotEndExclusive; ++i) {
            if (!(toInsert = destination.insertItem(i, toInsert, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return toInsert;
    }

    public static void transferItemsBetween(IItemHandler source, IItemHandler destination, Predicate<ItemStack> predicate) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack sourceItem = source.getStackInSlot(i);
            if (sourceItem.isEmpty() || !predicate.test(sourceItem)) continue;
            ItemStack inserted = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)sourceItem, (boolean)false);
            int insertCount = sourceItem.getCount() - inserted.getCount();
            if (insertCount <= 0) continue;
            source.extractItem(i, insertCount, false);
        }
    }

    public static void transferItemsBetween(IItemHandler source, IItemHandler destination) {
        LimaItemHandlerUtil.transferItemsBetween(source, destination, LimaItemUtil.ALWAYS_TRUE);
    }

    public static void transferBetweenInventories(IItemHandler source, IItemHandler destination, int sourceSlotStart, int sourceSlotEnd) {
        LimaCoreMath.validateOpenIndexRange(sourceSlotStart, sourceSlotEnd, source.getSlots());
        for (int i = sourceSlotStart; i < sourceSlotEnd; ++i) {
            ItemStack sourceItem = source.getStackInSlot(i);
            if (sourceItem.isEmpty()) continue;
            ItemStack inserted = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)sourceItem, (boolean)false);
            int insertCount = sourceItem.getCount() - inserted.getCount();
            if (insertCount <= 0) continue;
            source.extractItem(i, insertCount, false);
        }
    }

    public static void transferBetweenInventories(IItemHandler source, IItemHandler destination, int sourceSlot) {
        LimaItemHandlerUtil.transferBetweenInventories(source, destination, sourceSlot, 1);
    }

    public static void transferBetweenInventories(IItemHandler source, IItemHandler destination) {
        LimaItemHandlerUtil.transferBetweenInventories(source, destination, 0, source.getSlots());
    }
}

