/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.gui;

import liedge.limacore.data.LimaEnumCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public enum HorizontalAlignment implements StringRepresentable
{
    LEFT("left"),
    CENTER("center"),
    RIGHT("right");

    public static final LimaEnumCodec<HorizontalAlignment> CODEC;
    private final String name;

    private HorizontalAlignment(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getX(int elementWidth, int screenWidth) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> (screenWidth - elementWidth) / 2;
            case 2 -> screenWidth - elementWidth;
        };
    }

    public int getAbsoluteX(int elementWidth, int screenWidth, int offset) {
        int x = this.getX(elementWidth, screenWidth);
        return this == RIGHT ? x - offset : x + offset;
    }

    public int getRelativeX(int elementWidth, int screenWidth, float position) {
        float x = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (float)screenWidth * position;
            case 1 -> (float)screenWidth * position - (float)elementWidth / 2.0f;
            case 2 -> (float)screenWidth * (1.0f - position) - (float)elementWidth;
        };
        return Mth.floor((float)x);
    }

    static {
        CODEC = LimaEnumCodec.create(HorizontalAlignment.class);
    }
}

