/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.capability.fluid.LimaFluidUtil;
import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.limacore.client.gui.LimaRenderable;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.slot.LimaFluidSlot;
import liedge.limacore.network.IndexedStreamData;
import liedge.limacore.network.NetworkSerializer;
import liedge.limacore.network.packet.ServerboundCustomMenuButtonPacket;
import liedge.limacore.network.packet.ServerboundFluidSlotClickPacket;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaItemUtil;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class LimaMenuScreen<M extends LimaMenu<?>>
extends AbstractContainerScreen<M> {
    public static final int DEFAULT_WIDTH = 176;
    public static final int DEFAULT_HEIGHT = 166;
    public static final int DEFAULT_LABEL_COLOR = 0x404040;
    private final List<LimaRenderable> tooltipWidgets = new ObjectArrayList();
    protected final int labelColor;
    protected final int primaryWidth;
    protected final int primaryHeight;
    protected int leftPadding;
    protected int rightPadding;
    protected int topPadding;
    protected int bottomPadding;
    protected int bottomPos;
    protected int rightPos;
    @Nullable
    protected LimaFluidSlot hoveredFluidSlot;

    protected LimaMenuScreen(M menu, Inventory inventory, Component title, int primaryWidth, int primaryHeight, int labelColor) {
        super(menu, inventory, title);
        this.primaryWidth = primaryWidth;
        this.primaryHeight = primaryHeight;
        this.labelColor = labelColor;
    }

    protected void init() {
        this.imageWidth = this.primaryWidth + this.leftPadding + this.rightPadding;
        this.imageHeight = this.primaryHeight + this.topPadding + this.bottomPadding;
        this.leftPos = (this.width - this.imageWidth) / 2 + this.leftPadding;
        this.topPos = (this.height - this.imageHeight) / 2 + this.topPadding;
        this.rightPos = this.leftPos + this.primaryWidth;
        this.bottomPos = this.topPos + this.primaryHeight;
        this.positionLabels();
        this.addWidgets();
        this.tooltipWidgets.clear();
        for (Renderable r : this.renderables) {
            if (!(r instanceof LimaRenderable)) continue;
            LimaRenderable w = (LimaRenderable)r;
            this.tooltipWidgets.add(w);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        FluidStack stack;
        super.renderTooltip(graphics, x, y);
        if (this.hoveredFluidSlot != null && !(stack = this.hoveredFluidSlot.getFluid()).isEmpty()) {
            ObjectArrayList lines = new ObjectArrayList();
            lines.add(stack.getHoverName());
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                String id = LimaRegistryUtil.getNonNullRegistryId(stack.getFluidHolder()).toString();
                lines.add(Component.literal((String)id).withStyle(ChatFormatting.DARK_GRAY));
            }
            lines.add(Component.literal((String)LimaFluidUtil.formatStoredFluidMillibucket(stack.getAmount(), this.hoveredFluidSlot.getCapacity())).withStyle(ChatFormatting.GRAY));
            graphics.renderTooltip(this.font, (List)lines, Optional.empty(), x, y);
        }
        for (LimaRenderable widget : this.tooltipWidgets) {
            if (!widget.isMouseOver(x, y) || !widget.hasTooltip()) continue;
            ObjectArrayList list = new ObjectArrayList();
            widget.createWidgetTooltip(((List)list)::add);
            graphics.renderComponentTooltipFromElements(this.font, (List)list, x, y, ItemStack.EMPTY);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, this.labelColor, false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.labelColor, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hoveredFluidSlot != null && LimaItemUtil.hasFluidHandlerCapability(((LimaMenu)this.menu).getCarried()) && this.isHovering(this.hoveredFluidSlot.x(), this.hoveredFluidSlot.y(), 16, 16, mouseX, mouseY)) {
            LimaFluidSlot.ClickAction action;
            switch (button) {
                case 0: {
                    LimaFluidSlot.ClickAction clickAction = LimaFluidSlot.ClickAction.DRAIN;
                    break;
                }
                case 1: {
                    LimaFluidSlot.ClickAction clickAction = LimaFluidSlot.ClickAction.FILL;
                    break;
                }
                default: {
                    LimaFluidSlot.ClickAction clickAction = action = null;
                }
            }
            if (action != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundFluidSlotClickPacket(((LimaMenu)this.menu).containerId, this.hoveredFluidSlot.index(), action), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.getFocused() != null && this.isDragging() && button == 0) {
            return this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void positionLabels() {
        this.titleLabelX = (this.primaryWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    protected abstract void addWidgets();

    @Nullable
    public LimaFluidSlot getHoveredFluidSlot() {
        return this.hoveredFluidSlot;
    }

    public <T> void sendCustomButtonData(int buttonId, T value, NetworkSerializer<T> serializer) {
        ServerboundCustomMenuButtonPacket packet = new ServerboundCustomMenuButtonPacket(((LimaMenu)this.menu).containerId, new IndexedStreamData<T>(buttonId, serializer, value));
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public <T> void sendCustomButtonData(int buttonId, T value, Supplier<? extends NetworkSerializer<T>> supplier) {
        this.sendCustomButtonData(buttonId, value, supplier.get());
    }

    public void sendUnitButtonData(int buttonId) {
        this.sendCustomButtonData(buttonId, Unit.INSTANCE, (NetworkSerializer)LimaCoreNetworkSerializers.UNIT.get());
    }

    public boolean scrollFocusedElementInXYBounds(int x1, int y1, int x2, int y2, double mouseX, double mouseY, double scrollX, double scrollY) {
        if (LimaGuiUtil.isMouseWithinXYBounds(mouseX, mouseY, x1, y1, x2, y2) && this.getFocused() != null) {
            return this.getFocused().mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return false;
    }

    public boolean scrollFocusedElementInArea(int x, int y, int width, int height, double mouseX, double mouseY, double scrollX, double scrollY) {
        if (LimaGuiUtil.isMouseWithinArea(mouseX, mouseY, x, y, width, height) && this.getFocused() != null) {
            return this.getFocused().mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return false;
    }

    @EventBusSubscriber(modid="limacore", value={Dist.CLIENT})
    private static class FluidSlotRenderer {
        private FluidSlotRenderer() {
        }

        @SubscribeEvent
        public static void renderFluidSlots(ContainerScreenEvent.Render.Foreground event) {
            AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
            if (abstractContainerScreen instanceof LimaMenuScreen) {
                LimaMenuScreen limaScreen = (LimaMenuScreen)abstractContainerScreen;
                GuiGraphics graphics = event.getGuiGraphics();
                int mouseX = event.getMouseX();
                int mouseY = event.getMouseY();
                limaScreen.hoveredFluidSlot = null;
                for (int i = 0; i < ((LimaMenu)limaScreen.menu).getFluidSlots().size(); ++i) {
                    LimaFluidSlot fluidSlot = ((LimaMenu)limaScreen.menu).getFluidSlots().get(i);
                    int slotX = fluidSlot.x();
                    int slotY = fluidSlot.y();
                    FluidStack stack = fluidSlot.getFluid();
                    if (!stack.isEmpty()) {
                        LimaGuiUtil.renderFluidWithAmount(graphics, stack, slotX, slotY);
                    }
                    if (!limaScreen.isHovering(slotX, slotY, 16, 16, mouseX, mouseY)) continue;
                    limaScreen.hoveredFluidSlot = fluidSlot;
                    AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)slotX, (int)slotY, (int)0);
                }
            }
        }
    }
}

