/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.gui;

import liedge.limacore.data.LimaEnumCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public enum VerticalAlignment implements StringRepresentable
{
    TOP("top"),
    CENTER("center"),
    BOTTOM("bottom");

    public static final LimaEnumCodec<VerticalAlignment> CODEC;
    private final String name;

    private VerticalAlignment(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getY(int elementHeight, int screenHeight) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> (screenHeight - elementHeight) / 2;
            case 2 -> screenHeight - elementHeight;
        };
    }

    public int getAbsoluteY(int elementHeight, int screenHeight, int offset) {
        int y = this.getY(elementHeight, screenHeight);
        return this == BOTTOM ? y - offset : y + offset;
    }

    public int getRelativeY(int elementHeight, int screenHeight, float position) {
        float y = switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (float)screenHeight * position;
            case 1 -> (float)screenHeight * position - (float)elementHeight / 2.0f;
            case 2 -> (float)screenHeight * (1.0f - position) - (float)elementHeight;
        };
        return Mth.floor((float)y);
    }

    static {
        CODEC = LimaEnumCodec.create(VerticalAlignment.class);
    }
}

