/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public final class LimaCoreRenderTypes {
    public static final RenderStateShard.ShaderStateShard POSITION_TEX_COLOR_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader);
    private static final Function<ResourceLocation, RenderType> POSITION_TEX_COLOR_SOLID = Util.memoize(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(POSITION_TEX_COLOR_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).createCompositeState(true);
        return RenderType.create((String)"position_tex_color_solid", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final Function<ResourceLocation, RenderType> POSITION_TEX_COLOR_TRANSLUCENT = Util.memoize(texture -> {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(POSITION_TEX_COLOR_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).createCompositeState(true);
        return RenderType.create((String)"position_tex_color_translucent", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    });
    public static final RenderType ITEM_POS_TEX_COLOR_SOLID = LimaCoreRenderTypes.positionTexColorSolid(InventoryMenu.BLOCK_ATLAS);
    public static final RenderType ITEM_POS_TEX_COLOR_TRANSLUCENT = LimaCoreRenderTypes.positionTexColorTranslucent(InventoryMenu.BLOCK_ATLAS);

    private LimaCoreRenderTypes() {
    }

    public static RenderType positionTexColorSolid(ResourceLocation texture) {
        return POSITION_TEX_COLOR_SOLID.apply(texture);
    }

    public static RenderType positionTexColorTranslucent(ResourceLocation texture) {
        return POSITION_TEX_COLOR_TRANSLUCENT.apply(texture);
    }
}

