/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import com.google.common.base.Preconditions;
import liedge.limacore.data.generation.ModelProviderExtensions;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class LimaBlockStateProvider
extends BlockStateProvider
implements ModelProviderExtensions {
    public static final int DEFAULT_Y_ANGLE_OFFSET = 180;
    private final ModResources resources;
    private final ExistingFileHelper helper;
    protected final ModelFile mcBlockBlock = new ModelFile.UncheckedModelFile("block/block");
    protected final ModelFile mcBlockCube = new ModelFile.UncheckedModelFile("block/cube");
    protected final ModelFile mcBlockCubeAll = new ModelFile.UncheckedModelFile("block/cube_all");

    public LimaBlockStateProvider(PackOutput output, ModResources resources, ExistingFileHelper helper) {
        super(output, resources.modid(), helper);
        this.resources = resources;
        this.helper = helper;
    }

    @Override
    public ModResources modResources() {
        return this.resources;
    }

    @Override
    public ExistingFileHelper fileHelper() {
        return this.helper;
    }

    public VariantBlockStateBuilder getVariantBuilder(Holder<Block> holder) {
        return this.getVariantBuilder((Block)holder.value());
    }

    protected void simpleBlock(Holder<Block> holder, ModelFile model) {
        this.simpleBlock((Block)holder.value(), model);
    }

    protected void simpleBlockItem(Holder<Block> holder, ModelFile model) {
        this.simpleBlockItem((Block)holder.value(), model);
    }

    protected void simpleBlockItem(Block block) {
        this.simpleBlockItem(block, this.existingModel(this.blockFolderLocation(block)));
    }

    protected void simpleBlockItem(Holder<Block> holder) {
        this.simpleBlockItem((Block)holder.value());
    }

    protected void simpleBlockWithItem(Holder<Block> holder, ModelFile model) {
        this.simpleBlockWithItem((Block)holder.value(), model);
    }

    protected void simpleBlockWithItem(Holder<Block> holder) {
        this.simpleBlockWithItem(holder, this.existingModel(this.blockFolderLocation(holder)));
    }

    public BlockModelBuilder cubeAll(Block block, ResourceLocation texture) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().cubeAll(LimaRegistryUtil.getBlockName(block), texture);
        this.simpleBlockWithItem(block, (ModelFile)builder);
        return builder;
    }

    public BlockModelBuilder cubeAll(Holder<Block> holder, ResourceLocation texture) {
        return this.cubeAll((Block)holder.value(), texture);
    }

    public BlockModelBuilder cubeAll(Holder<Block> holder, String texture) {
        return this.cubeAll(holder, this.blockFolderLocation(texture));
    }

    public BlockModelBuilder cubeAll(Block block) {
        return this.cubeAll(block, this.blockFolderLocation(block));
    }

    public BlockModelBuilder cubeAll(Holder<Block> holder) {
        return this.cubeAll((Block)holder.value());
    }

    protected void liquidBlock(Holder<Block> holder) {
        String name = LimaRegistryUtil.getBlockName(holder);
        ModelBuilder model = ((BlockModelBuilder)this.getBlockBuilder(holder).texture("particle", this.blockFolderLocation(name + "_still"))).renderType("translucent");
        this.simpleBlock(holder, (ModelFile)model);
    }

    protected int getRotationX(Direction side) {
        Preconditions.checkArgument((boolean)side.getAxis().isVertical(), (Object)"Direction must be vertical for x rotation calculation");
        return side == Direction.DOWN ? 90 : 270;
    }

    protected int getRotationY(Direction side, int angleOffset) {
        Preconditions.checkArgument((boolean)side.getAxis().isHorizontal(), (Object)"Direction must be horizontal for y rotation calculation");
        return ((int)side.toYRot() + angleOffset) % 360;
    }

    protected int getRotationY(Direction side) {
        return this.getRotationY(side, 180);
    }

    protected ItemModelBuilder getItemBuilder(Block block) {
        return (ItemModelBuilder)this.itemModels().getBuilder(LimaRegistryUtil.getItemName(block.asItem()));
    }

    protected ItemModelBuilder getItemBuilder(Holder<Block> holder) {
        return this.getItemBuilder((Block)holder.value());
    }

    protected BlockModelBuilder getBlockBuilder(Block block) {
        return (BlockModelBuilder)this.models().getBuilder(LimaRegistryUtil.getBlockName(block));
    }

    protected BlockModelBuilder getBlockBuilder(Holder<Block> holder) {
        return (BlockModelBuilder)this.models().getBuilder(LimaRegistryUtil.getBlockName(holder));
    }
}

