/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import liedge.limacore.lib.ModResources;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.ParticleDescriptionProvider;

public abstract class LimaParticleDescriptionProvider
extends ParticleDescriptionProvider {
    private final ModResources resources;

    protected LimaParticleDescriptionProvider(PackOutput output, ModResources resources, ExistingFileHelper fileHelper) {
        super(output, fileHelper);
        this.resources = resources;
    }

    protected void sprite(ParticleType<?> type, String modTexture) {
        this.sprite(type, this.resources.location(modTexture));
    }

    protected void sprite(Holder<ParticleType<?>> typeHolder, ResourceLocation texture) {
        this.sprite((ParticleType)typeHolder.value(), texture);
    }

    protected void sprite(Holder<ParticleType<?>> typeHolder, String modTexture) {
        this.sprite((ParticleType)typeHolder.value(), modTexture);
    }

    protected void spriteSet(Holder<ParticleType<?>> typeHolder, ResourceLocation baseTexture, int numOfSprites, boolean reverse) {
        this.spriteSet((ParticleType)typeHolder.value(), baseTexture, numOfSprites, reverse);
    }

    protected void spriteSet(ParticleType<?> type, String modTextureName, int numOfSprites, boolean reverse) {
        this.spriteSet(type, this.resources.location(modTextureName), numOfSprites, reverse);
    }

    protected void spriteSet(Holder<ParticleType<?>> typeHolder, String modTextureName, int numOfSprites, boolean reverse) {
        this.spriteSet((ParticleType)typeHolder.value(), modTextureName, numOfSprites, reverse);
    }

    protected void spriteSet(ParticleType<?> type, ResourceLocation baseTexture, int startInclusive, int endExclusive, boolean reverse) {
        this.spriteSet(type, this.textures(baseTexture, startInclusive, endExclusive, reverse));
    }

    protected void spriteSet(Holder<ParticleType<?>> typeHolder, ResourceLocation baseTexture, int startInclusive, int endExclusive, boolean reverse) {
        this.spriteSet((ParticleType)typeHolder.value(), baseTexture, startInclusive, endExclusive, reverse);
    }

    protected void spriteSet(ParticleType<?> type, String modTextureName, int startInclusive, int endExclusive, boolean reverse) {
        this.spriteSet(type, this.resources.location(modTextureName), startInclusive, endExclusive, reverse);
    }

    protected void spriteSet(Holder<ParticleType<?>> typeHolder, String modTextureName, int startInclusive, int endExclusive, boolean reverse) {
        this.spriteSet((ParticleType)typeHolder.value(), modTextureName, startInclusive, endExclusive, reverse);
    }

    protected Iterable<ResourceLocation> textures(final ResourceLocation baseTexture, final int startInclusive, final int endExclusive, final boolean reverse) {
        Preconditions.checkArgument((startInclusive >= 0 ? 1 : 0) != 0, (Object)"Particle sprites must start at or higher than 0");
        Preconditions.checkArgument((endExclusive - startInclusive > 1 ? 1 : 0) != 0, (Object)"Sprite end index must be greater than start index by more than 1");
        return () -> new Iterator<ResourceLocation>(this){
            private int counter = 0;
            private final int limit = endExclusive - startInclusive;

            @Override
            public boolean hasNext() {
                return this.counter < this.limit;
            }

            @Override
            public ResourceLocation next() {
                int n = reverse ? endExclusive - this.counter - 1 : startInclusive + this.counter;
                ++this.counter;
                return baseTexture.withSuffix("_" + n);
            }
        };
    }
}

