/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import java.util.concurrent.CompletableFuture;
import liedge.limacore.data.generation.recipe.LimaCookingRecipeBuilder;
import liedge.limacore.data.generation.recipe.LimaShapedRecipeBuilder;
import liedge.limacore.data.generation.recipe.LimaShapelessRecipeBuilder;
import liedge.limacore.data.generation.recipe.LimaStonecuttingRecipeBuilder;
import liedge.limacore.lib.ModResources;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;

public abstract class LimaRecipeProvider
extends RecipeProvider {
    protected final ModResources modResources;

    public LimaRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ModResources modResources) {
        super(output, registries);
        this.modResources = modResources;
    }

    protected abstract void buildRecipes(RecipeOutput var1, HolderLookup.Provider var2);

    @Deprecated
    protected final void buildRecipes(RecipeOutput output) {
    }

    protected LimaShapedRecipeBuilder shaped(ItemStack result) {
        return new LimaShapedRecipeBuilder(this.modResources, result);
    }

    protected LimaShapedRecipeBuilder shaped(ItemLike item, int count) {
        return this.shaped(this.stackOf(item, count));
    }

    protected LimaShapedRecipeBuilder shaped(ItemLike item) {
        return this.shaped(this.stackOf(item));
    }

    protected LimaShapelessRecipeBuilder shapeless(ItemStack result) {
        return new LimaShapelessRecipeBuilder(this.modResources, result);
    }

    protected LimaShapelessRecipeBuilder shapeless(ItemLike item, int count) {
        return this.shapeless(this.stackOf(item, count));
    }

    protected LimaShapelessRecipeBuilder shapeless(ItemLike item) {
        return this.shapeless(this.stackOf(item));
    }

    protected LimaStonecuttingRecipeBuilder stonecutting(ItemStack result) {
        return new LimaStonecuttingRecipeBuilder(this.modResources, result);
    }

    protected LimaStonecuttingRecipeBuilder stonecutting(ItemLike item, int count) {
        return this.stonecutting(this.stackOf(item, count));
    }

    protected LimaStonecuttingRecipeBuilder stonecutting(ItemLike item) {
        return this.stonecutting(this.stackOf(item));
    }

    protected LimaCookingRecipeBuilder smelting(ItemStack result) {
        return new LimaCookingRecipeBuilder(this.modResources, result, 200, SmeltingRecipe::new);
    }

    protected LimaCookingRecipeBuilder smelting(ItemLike item) {
        return this.smelting(this.stackOf(item));
    }

    protected LimaCookingRecipeBuilder blasting(ItemStack result) {
        return new LimaCookingRecipeBuilder(this.modResources, result, 100, BlastingRecipe::new);
    }

    protected LimaCookingRecipeBuilder blasting(ItemLike item) {
        return this.blasting(this.stackOf(item));
    }

    protected LimaCookingRecipeBuilder smoking(ItemStack result) {
        return new LimaCookingRecipeBuilder(this.modResources, result, 100, SmokingRecipe::new);
    }

    protected LimaCookingRecipeBuilder smoking(ItemLike item) {
        return this.smoking(this.stackOf(item));
    }

    protected LimaShapedRecipeBuilder shaped3x3(ItemLike input, ItemStack result) {
        return this.shaped(result).input('#', input).patterns("###", "###", "###");
    }

    protected LimaShapedRecipeBuilder shaped2x2(ItemLike input, ItemStack result) {
        return this.shaped(result).input('#', input).patterns("##", "##");
    }

    protected void nuggetIngotBlockRecipes(RecipeOutput output, String materialName, ItemLike nugget, ItemLike ingot, ItemLike block) {
        this.shaped3x3(nugget, new ItemStack(ingot)).save(output, materialName + "_nuggets_to_ingot");
        ((LimaShapelessRecipeBuilder)this.shapeless(new ItemStack(nugget, 9)).input(Ingredient.of((ItemLike[])new ItemLike[]{ingot}))).save(output, materialName + "_ingot_to_nuggets");
        this.shaped3x3(ingot, new ItemStack(block)).save(output, materialName + "_ingots_to_block");
        ((LimaShapelessRecipeBuilder)this.shapeless(new ItemStack(ingot, 9)).input(Ingredient.of((ItemLike[])new ItemLike[]{block}))).save(output, materialName + "_block_to_ingots");
    }

    protected void nineStorageRecipes(RecipeOutput output, ItemLike unpackedItem, ItemLike packedItem) {
        String recipeName = LimaRecipeProvider.getItemName((ItemLike)unpackedItem);
        this.shaped3x3(unpackedItem, this.stackOf(packedItem)).save(output, "pack_9_" + recipeName);
        ((LimaShapelessRecipeBuilder)this.shapeless(this.stackOf(unpackedItem, 9)).input(packedItem)).save(output, "unpack_9_" + recipeName);
    }

    protected void fourStorageRecipes(RecipeOutput output, ItemLike unpackedItem, ItemLike packedItem) {
        String recipeName = LimaRecipeProvider.getItemName((ItemLike)unpackedItem);
        this.shaped2x2(unpackedItem, this.stackOf(packedItem)).save(output, "pack_4_" + recipeName);
        ((LimaShapelessRecipeBuilder)this.shapeless(this.stackOf(unpackedItem, 4)).input(packedItem)).save(output, "unpack_4_" + recipeName);
    }

    protected void oreSmeltBlast(RecipeOutput recipeOutput, String recipeName, Ingredient input, ItemStack result) {
        ((LimaCookingRecipeBuilder)this.smelting(result).input(input)).xp(0.7f).save(recipeOutput, recipeName);
        ((LimaCookingRecipeBuilder)this.blasting(result).input(input)).xp(0.7f).save(recipeOutput, recipeName);
    }

    protected void oreSmeltBlast(RecipeOutput recipeOutput, String recipeName, ItemLike input, ItemStack result) {
        ((LimaCookingRecipeBuilder)this.smelting(result).input(input)).xp(0.7f).save(recipeOutput, recipeName);
        ((LimaCookingRecipeBuilder)this.blasting(result).input(input)).xp(0.7f).save(recipeOutput, recipeName);
    }

    protected ItemStack stackOf(ItemLike item, int count) {
        return new ItemStack(item, count);
    }

    protected ItemStack stackOf(ItemLike item) {
        return new ItemStack(item);
    }
}

