/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation;

import java.util.function.UnaryOperator;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public abstract class LimaSoundDefinitionsProvider
extends SoundDefinitionsProvider {
    private final ModResources resources;

    public static String defaultSubtitleKey(ResourceLocation id) {
        return ModResources.prefixedIdLangKey("subtitle", id);
    }

    public static String defaultSubtitleKey(Holder<SoundEvent> holder) {
        return LimaSoundDefinitionsProvider.defaultSubtitleKey(LimaRegistryUtil.getNonNullRegistryId(holder));
    }

    protected LimaSoundDefinitionsProvider(PackOutput output, ModResources resources, ExistingFileHelper helper) {
        super(output, resources.modid(), helper);
        this.resources = resources;
    }

    protected SoundDefinition.Sound beginSound(SoundEvent soundEvent, SoundDefinition.SoundType soundType) {
        return LimaSoundDefinitionsProvider.sound((ResourceLocation)LimaRegistryUtil.getNonNullRegistryId(soundEvent, BuiltInRegistries.SOUND_EVENT), (SoundDefinition.SoundType)soundType);
    }

    protected SoundDefinition.Sound beginSound(Holder<SoundEvent> holder, SoundDefinition.SoundType soundType) {
        return this.beginSound((SoundEvent)holder.value(), soundType);
    }

    protected SoundDefinition.Sound beginSound(String soundFilePath, SoundDefinition.SoundType soundType) {
        return LimaSoundDefinitionsProvider.sound((ResourceLocation)this.resources.location(soundFilePath), (SoundDefinition.SoundType)soundType);
    }

    protected SoundDefinition beginDefinition(ResourceLocation soundEventId) {
        return SoundDefinition.definition().subtitle(LimaSoundDefinitionsProvider.defaultSubtitleKey(soundEventId));
    }

    protected SoundDefinition beginDefinition(String soundEventName) {
        return this.beginDefinition(this.resources.location(soundEventName));
    }

    protected SoundDefinition beginDefinition(SoundEvent soundEvent) {
        return this.beginDefinition(LimaRegistryUtil.getNonNullRegistryId(soundEvent, BuiltInRegistries.SOUND_EVENT));
    }

    protected SoundDefinition beginDefinition(Holder<SoundEvent> holder) {
        return this.beginDefinition((SoundEvent)holder.value());
    }

    protected void addSound(Holder<SoundEvent> holder, SoundDefinition definition) {
        this.add((SoundEvent)holder.value(), definition);
    }

    protected void addSound(SoundEvent event, UnaryOperator<SoundDefinition> op) {
        this.add(event, (SoundDefinition)op.apply(this.beginDefinition(event)));
    }

    protected void addSound(Holder<SoundEvent> holder, UnaryOperator<SoundDefinition> op) {
        this.addSound(holder, (SoundDefinition)op.apply(this.beginDefinition(holder)));
    }

    protected void addSingleDirectSound(Holder<SoundEvent> holder) {
        this.addSound(holder, def -> def.with(this.beginSound(holder, SoundDefinition.SoundType.SOUND)));
    }

    protected void addSingleDirectSound(Holder<SoundEvent> holder, String soundFilePath) {
        this.addSound(holder, def -> def.with(this.beginSound(soundFilePath, SoundDefinition.SoundType.SOUND)));
    }

    protected void addSingleEventSound(Holder<SoundEvent> holder, SoundEvent targetSound) {
        this.addSound(holder, def -> def.with(this.beginSound(targetSound, SoundDefinition.SoundType.EVENT)));
    }

    protected void addSingleEventSound(Holder<SoundEvent> holder, Holder<SoundEvent> targetSoundHolder) {
        this.addSingleEventSound(holder, (SoundEvent)targetSoundHolder.value());
    }
}

