/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation.builtin;

import liedge.limacore.LimaCore;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.RelativeHorizontalSide;
import liedge.limacore.client.LimaComponentUtil;
import liedge.limacore.data.generation.LimaLanguageProvider;
import liedge.limacore.lib.Translatable;
import liedge.limacore.lib.damage.DamageReductionType;
import liedge.limacore.registry.game.LimaCoreAttributes;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;

class LanguageGen
extends LimaLanguageProvider {
    LanguageGen(PackOutput output) {
        super(output, LimaCore.RESOURCES);
    }

    protected void addTranslations() {
        this.add(((RangedAttribute)LimaCoreAttributes.DAMAGE_MULTIPLIER.get()).getDescriptionId(), "Damage Multiplier");
        this.add(((RangedAttribute)LimaCoreAttributes.KNOCKBACK_MULTIPLIER.get()).getDescriptionId(), "Knockback Multiplier");
        for (DamageReductionType damageReductionType : DamageReductionType.values()) {
            this.add(damageReductionType, LanguageGen.localizeSimpleName(damageReductionType));
        }
        for (Enum enum_ : IOAccess.values()) {
            String value = enum_ == IOAccess.INPUT_AND_OUTPUT ? "Input/Output" : LanguageGen.localizeSimpleName((StringRepresentable)enum_);
            this.add((Translatable)((Object)enum_), value);
        }
        for (Enum enum_ : Direction.values()) {
            this.add(LimaComponentUtil.localizeDirection((Direction)enum_), LanguageGen.localizeSimpleName((StringRepresentable)enum_));
        }
        for (Enum enum_ : RelativeHorizontalSide.values()) {
            this.add((Translatable)((Object)enum_), LanguageGen.localizeSimpleName((StringRepresentable)enum_));
        }
    }
}

