/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation.loot;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import liedge.limacore.data.generation.loot.LimaLootSubProviderExtensions;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.limacore.world.loot.SaveBlockEntityFunction;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class LimaBlockLootSubProvider
extends BlockLootSubProvider
implements LimaLootSubProviderExtensions {
    private final String modid;

    protected LimaBlockLootSubProvider(HolderLookup.Provider provider, String modid) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        this.modid = modid;
    }

    protected Iterable<Block> getKnownBlocks() {
        return LimaRegistryUtil.allNamespaceRegistryValues(this.modid, BuiltInRegistries.BLOCK).toList();
    }

    protected void add(Holder<Block> holder, LootTable.Builder builder) {
        this.add((Block)holder.value(), builder);
    }

    protected void add(Holder<Block> holder, Function<Block, LootTable.Builder> factory) {
        this.add((Block)holder.value(), factory);
    }

    protected void dropSelf(Holder<Block> holder) {
        this.dropSelf((Block)holder.value());
    }

    protected void dropSelf(Collection<? extends Holder<Block>> holders) {
        holders.forEach(this::dropSelf);
    }

    @SafeVarargs
    protected final void dropSelf(Holder<Block> ... holders) {
        Stream.of(holders).forEach(this::dropSelf);
    }

    protected void dropSelfWithEntity(Block block) {
        this.add(block, this.singlePoolTable(((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)this.singleItemPool((ItemLike)block))).apply(SaveBlockEntityFunction.saveBlockEntityData())));
    }

    protected void dropSelfWithEntity(Holder<Block> holder) {
        this.dropSelfWithEntity((Block)holder.value());
    }

    protected void oreDrop(Block oreBlock, ItemLike rawOreItem) {
        this.add(oreBlock, this.createOreDrop(oreBlock, rawOreItem.asItem()));
    }

    protected void oreDrop(Holder<Block> oreBlockHolder, ItemLike rawOreItem) {
        this.oreDrop((Block)oreBlockHolder.value(), rawOreItem);
    }

    protected <T extends Comparable<T> & StringRepresentable> LootItemCondition.Builder matchStateProperty(Block block, Property<T> property, T value) {
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, value));
    }

    protected <T extends Comparable<T> & StringRepresentable> LootItemCondition.Builder matchStateProperty(Holder<Block> holder, Property<T> property, T value) {
        return this.matchStateProperty((Block)holder.value(), property, value);
    }
}

