/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.data.generation.recipe;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import liedge.limacore.data.generation.recipe.LimaRecipeBuilder;
import liedge.limacore.lib.ModResources;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public abstract class StandardRecipeBuilder<R extends Recipe<?>, B extends StandardRecipeBuilder<R, B>>
extends LimaRecipeBuilder<R, B> {
    protected final List<Ingredient> ingredients = new ObjectArrayList();
    protected final ItemStack result;

    protected StandardRecipeBuilder(ModResources resources, ItemStack result) {
        super(resources);
        this.result = result;
    }

    public B input(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return (B)((StandardRecipeBuilder)this.selfUnchecked());
    }

    public B input(ItemLike item) {
        return this.input(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public B input(TagKey<Item> tagKey) {
        return this.input(Ingredient.of(tagKey));
    }

    @Override
    protected String getDefaultRecipeName() {
        return LimaRegistryUtil.getItemName(this.result);
    }
}

