/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.event;

import liedge.limacore.registry.game.LimaCoreAttributes;
import liedge.limacore.registry.game.LimaCoreTriggerTypes;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="limacore")
public final class LimaCoreEventHandler {
    private LimaCoreEventHandler() {
    }

    @SubscribeEvent
    static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((PlayerTrigger)LimaCoreTriggerTypes.PLAYER_LOGGED_IN.get()).trigger(serverPlayer);
        }
    }

    @SubscribeEvent
    static void onLivingKnockback(LivingKnockBackEvent event) {
        double modifier = event.getEntity().getAttributeValue(LimaCoreAttributes.KNOCKBACK_MULTIPLIER);
        if (modifier == 1.0) {
            return;
        }
        double newStrength = (double)event.getStrength() * modifier;
        event.setStrength((float)newStrength);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        LivingEntity attacker;
        double damageModifier;
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity && (damageModifier = (attacker = (LivingEntity)entity).getAttributeValue(LimaCoreAttributes.DAMAGE_MULTIPLIER)) != 1.0) {
            double newDamage = (double)event.getAmount() * damageModifier;
            event.setAmount((float)newDamage);
        }
    }
}

