/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import liedge.limacore.data.LimaCoreCodecs;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;

public record LimaColor(int argb32, float red, float green, float blue, Style chatStyle) {
    public static final LimaColor WHITE = LimaColor.createOpaque(0xFFFFFF);
    public static final LimaColor BLACK = LimaColor.createOpaque(0);
    public static final Codec<LimaColor> CODEC = Codec.withAlternative((Codec)Codec.INT, LimaCoreCodecs.HEXADECIMAL_INT).xmap(LimaColor::createOpaque, LimaColor::argb32);
    public static final StreamCodec<ByteBuf, LimaColor> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(LimaColor::createOpaque, LimaColor::argb32);

    private LimaColor(int argb32, float red, float green, float blue) {
        this(argb32, red, green, blue, Style.EMPTY.withColor(argb32));
    }

    public static LimaColor createOpaque(int rgb) {
        int argb32 = FastColor.ARGB32.opaque((int)rgb);
        float red = (float)FastColor.ARGB32.red((int)argb32) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)argb32) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)argb32) / 255.0f;
        return new LimaColor(argb32, red, green, blue);
    }

    public static LimaColor createOpaque(float red, float green, float blue) {
        int argb32 = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)red, (float)green, (float)blue);
        return new LimaColor(argb32, red, green, blue);
    }

    public Style applyChatStyle(Style style) {
        return style.withColor(this.argb32);
    }

    @Override
    public String toString() {
        return "#" + Integer.toHexString(this.argb32);
    }
}

