/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib;

import java.util.Set;
import liedge.limacore.util.LimaCollectionsUtil;

public interface OrderedEnum<E extends Enum<E>> {
    public static <T extends Enum<T>> T nextAvailable(Set<T> validValues, T current) {
        if (validValues.isEmpty()) {
            return current;
        }
        if (validValues.size() == 1) {
            return (T)((Enum)validValues.iterator().next());
        }
        T next = null;
        while (next == null) {
            if (!validValues.contains(current = ((OrderedEnum)current).next())) continue;
            next = current;
        }
        return next;
    }

    public static <T extends Enum<T>> T previousAvailable(Set<T> validValues, T current) {
        if (validValues.isEmpty()) {
            return current;
        }
        if (validValues.size() == 1) {
            return (T)((Enum)validValues.iterator().next());
        }
        T next = null;
        while (next == null) {
            if (!validValues.contains(current = ((OrderedEnum)current).previous())) continue;
            next = current;
        }
        return next;
    }

    default public E previous() {
        int len = this.count();
        int i = (this.ordinal() - 1 + len) % len;
        return (E)this.enumValues()[i];
    }

    default public E next() {
        int len = this.count();
        int i = (this.ordinal() + 1) % len;
        return (E)this.enumValues()[i];
    }

    public int ordinal();

    public Class<E> getDeclaringClass();

    private int count() {
        return this.enumValues().length;
    }

    private E[] enumValues() {
        return LimaCollectionsUtil.checkedEnumConstants(this.getDeclaringClass());
    }
}

