/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import liedge.limacore.lib.math.LimaCoreMath;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TickTimer {
    private int duration = 1;
    private int currentTick;
    private int previousTick;
    private State timerState = State.STOPPED;
    @Nullable
    private Runnable onStart;
    @Nullable
    private BooleanConsumer onStopped;

    public static TickTimer create() {
        return new TickTimer();
    }

    public TickTimer withStartCallback(@Nullable Runnable onStart) {
        this.onStart = onStart;
        return this;
    }

    public TickTimer withStopCallback(@Nullable BooleanConsumer onStopped) {
        this.onStopped = onStopped;
        return this;
    }

    public void startTimer(int duration) {
        this.startTimer(duration, false);
    }

    public void startTimer(int duration, boolean pauseOnStart) {
        if (duration > 0) {
            this.duration = duration;
            this.currentTick = 0;
            this.previousTick = 0;
            if (this.onStart != null) {
                this.onStart.run();
            }
            this.timerState = pauseOnStart ? State.PAUSED : State.RUNNING;
        }
    }

    public void stopTimer() {
        if (this.timerState != State.STOPPED) {
            this.currentTick = this.duration;
            this.previousTick = this.duration;
            this.timerState = State.STOPPED;
            if (this.onStopped != null) {
                this.onStopped.accept(false);
            }
        }
    }

    public void setPaused(boolean paused) {
        if (paused && this.timerState == State.RUNNING) {
            this.timerState = State.PAUSED;
        } else if (this.timerState == State.PAUSED && !paused) {
            this.timerState = State.RUNNING;
        }
    }

    public State getTimerState() {
        return this.timerState;
    }

    public void tickTimer() {
        if (this.timerState == State.RUNNING) {
            if (this.currentTick < this.duration) {
                this.previousTick = this.currentTick++;
            } else if (this.currentTick == this.duration && this.previousTick < this.duration) {
                this.previousTick = this.duration;
                this.timerState = State.STOPPED;
                if (this.onStopped != null) {
                    this.onStopped.accept(true);
                }
            }
        }
    }

    public float getProgressPercent() {
        return LimaCoreMath.divideFloat(this.currentTick, this.duration);
    }

    public boolean isRunningClient() {
        return this.timerState == State.RUNNING && this.previousTick < this.duration;
    }

    public float lerpTick(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.previousTick, (float)this.currentTick);
    }

    public float lerpProgressNotPaused(float partialTick) {
        if (this.isRunningClient()) {
            return LimaCoreMath.divideFloatLerp(partialTick, this.previousTick, this.currentTick, this.duration);
        }
        return 0.0f;
    }

    public float lerpPausedProgress(float partialTick) {
        if (this.isRunningClient()) {
            return LimaCoreMath.divideFloatLerp(partialTick, this.previousTick, this.currentTick, this.duration);
        }
        return LimaCoreMath.divideFloat(this.currentTick, this.duration);
    }

    public static enum State {
        RUNNING,
        STOPPED,
        PAUSED;

    }
}

