/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib.damage;

import liedge.limacore.LimaCore;
import liedge.limacore.data.LimaEnumCodec;
import liedge.limacore.lib.Translatable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum DamageReductionType implements StringRepresentable,
Translatable
{
    ARMOR("armor", DamageContainer.Reduction.ARMOR),
    ENCHANTMENTS("enchantments", DamageContainer.Reduction.ENCHANTMENTS),
    MOB_EFFECTS("mob_effects", DamageContainer.Reduction.MOB_EFFECTS),
    ABSORPTION("absorption", DamageContainer.Reduction.ABSORPTION);

    public static final LimaEnumCodec<DamageReductionType> CODEC;
    public static final StreamCodec<FriendlyByteBuf, DamageReductionType> STREAM_CODEC;
    private final String name;
    private final String langKey;
    private final DamageContainer.Reduction reduction;

    private DamageReductionType(String name, DamageContainer.Reduction reduction) {
        this.name = name;
        this.langKey = LimaCore.RESOURCES.translationKey("reduction_type.{}", name);
        this.reduction = reduction;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Override
    public String descriptionId() {
        return this.langKey;
    }

    public DamageContainer.Reduction getReduction() {
        return this.reduction;
    }

    static {
        CODEC = LimaEnumCodec.create(DamageReductionType.class);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(DamageReductionType.class);
    }
}

