/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib.math;

import com.mojang.serialization.Codec;
import liedge.limacore.data.LimaEnumCodec;
import net.minecraft.util.StringRepresentable;

public enum CompareOperation implements StringRepresentable
{
    EQUALS("equals"),
    GREATER_THAN("greater_than"),
    LESS_THAN("less_than"),
    GREATER_THAN_OR_EQUALS("greater_than_or_equals"),
    LESS_THAN_OR_EQUALS("less_than_or_equals");

    public static final Codec<CompareOperation> CODEC;
    private final String name;

    private CompareOperation(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public boolean test(double left, double right) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (left == right) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (left > right) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (left < right) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (left >= right) {
                    yield true;
                }
                yield false;
            }
            case 4 -> left <= right;
        };
    }

    static {
        CODEC = LimaEnumCodec.create(CompareOperation.class);
    }
}

