/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.lib.math;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import liedge.limacore.lib.math.LimaRoundingMode;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.joml.Vector3f;

public final class LimaCoreMath {
    public static final Random RANDOM = new Random(13L);
    public static final int THOUSAND = 1000;
    public static final int MILLION = 1000000;
    public static final int BILLION = 1000000000;
    private static final Vec3 Y_UNIT_VEC = new Vec3(0.0, 1.0, 0.0);

    private LimaCoreMath() {
    }

    public static int parseHexadecimal(String value) throws NumberFormatException {
        value = value.startsWith("#") ? value.substring(1) : value;
        return Integer.parseInt(value, 16);
    }

    public static Optional<Integer> tryParseHexadecimal(String value) {
        try {
            return Optional.of(LimaCoreMath.parseHexadecimal(value));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static float divideFloat(float dividend, float divisor) {
        return divisor != 0.0f ? dividend / divisor : 0.0f;
    }

    public static double divideDouble(double dividend, double divisor) {
        return divisor != 0.0 ? dividend / divisor : 0.0;
    }

    public static float divideFloatLerp(float partialTick, float dividendStart, float dividendEnd, float divisor) {
        return LimaCoreMath.divideFloat(Mth.lerp((float)partialTick, (float)dividendStart, (float)dividendEnd), divisor);
    }

    public static int nextIntBetweenInclusive(int min, int max) {
        return RANDOM.nextInt(min, max + 1);
    }

    public static boolean rollRandomChance(double chance) {
        return RANDOM.nextDouble() <= chance;
    }

    public static int valueOf(boolean bool) {
        return bool ? 1 : 0;
    }

    public static void validateOpenIndexRange(int start, int end, int size) {
        if (start < 0 || start >= size || end > size) {
            throw new IllegalArgumentException(String.format("Index range [%s,%s) out of bounds: [0,%s)", start, end, size));
        }
        if (start > end) {
            throw new IllegalArgumentException(String.format("Start index %s cannot be higher than open end index %s", start, end));
        }
    }

    public static int roundRandomly(double value) {
        int base = (int)value;
        if ((double)base == value) {
            return base;
        }
        double d = value - (double)base;
        int n = LimaCoreMath.valueOf(LimaCoreMath.rollRandomChance(Math.abs(d))) * Mth.sign((double)d);
        return base + n;
    }

    public static int round(double value) {
        return LimaCoreMath.round(value, LimaRoundingMode.NATURAL);
    }

    public static int round(double value, LimaRoundingMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case LimaRoundingMode.NATURAL -> (int)Math.round(value);
            case LimaRoundingMode.FLOOR -> Mth.floor((double)value);
            case LimaRoundingMode.CEIL -> Mth.ceil((double)value);
            case LimaRoundingMode.RANDOM -> LimaCoreMath.roundRandomly(value);
        };
    }

    public static double triangle(double min, double max) {
        return min + max * (RANDOM.nextDouble() - RANDOM.nextDouble());
    }

    public static float toDeg(float angle) {
        return angle * 57.295776f;
    }

    public static float toDeg(double angle) {
        return (float)angle * 57.295776f;
    }

    public static float toRad(float angle) {
        return angle * ((float)Math.PI / 180);
    }

    public static float toRad(double angle) {
        return (float)angle * ((float)Math.PI / 180);
    }

    public static double vec3Length(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double vec3Length(Vec3 vec) {
        return LimaCoreMath.vec3Length(vec.x(), vec.y(), vec.z());
    }

    public static double vec2Length(double x, double z) {
        return Math.sqrt(x * x + z * z);
    }

    public static double vec2Length(Vec3 vec) {
        return LimaCoreMath.vec2Length(vec.x, vec.z);
    }

    public static double distanceBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static Vec3 normalizedCross(Vec3 a, Vec3 b) {
        double x = a.y * b.z - a.z * b.y;
        double y = a.z * b.x - a.x * b.z;
        double z = a.x * b.y - a.y * b.x;
        double u = Math.sqrt(x * x + y * y + z * z);
        return u < 1.0E-6 ? Vec3.ZERO : new Vec3(x / u, y / u, z / u);
    }

    public static Vec3 relativePointToRotations(float xRot, float yRot, double xOffset, double yOffset, double zOffset) {
        Vec3 dir = LimaCoreMath.createMotionVector(xRot, yRot, 1.0);
        Vec3 vecZ = LimaCoreMath.createMotionVector(0.0f, yRot, 1.0);
        Vec3 vecX = vecZ.cross(Y_UNIT_VEC);
        float xRotRad = LimaCoreMath.toRad(xRot);
        float cosY = Mth.cos((float)xRotRad);
        float sinY = Mth.sin((float)xRotRad);
        double nx = dir.x * zOffset + vecX.x * xOffset + -vecZ.x * yOffset * (double)sinY;
        double ny = dir.y * zOffset + vecX.y * xOffset + -yOffset * (double)cosY;
        double nz = dir.z * zOffset + vecX.z * xOffset + -vecZ.z * yOffset * (double)sinY;
        return new Vec3(nx, ny, nz);
    }

    public static Vec3 relativePointToRotations(Entity entity, double xOffset, double yOffset, double zOffset) {
        return LimaCoreMath.relativePointToRotations(entity.getViewXRot(1.0f), entity.getViewYRot(1.0f), xOffset, yOffset, zOffset);
    }

    public static Stream<Vec3> relativePointsToRotations(float xRot, float yRot, List<Vec3> list) {
        Vec3 dir = LimaCoreMath.createMotionVector(xRot, yRot, 1.0);
        Vec3 vecZ = LimaCoreMath.createMotionVector(0.0f, yRot, 1.0);
        Vec3 vecX = vecZ.cross(Y_UNIT_VEC);
        float yRotRad = LimaCoreMath.toRad(yRot);
        float sinY = Mth.sin((float)yRotRad);
        float cosY = Mth.cos((float)yRotRad);
        return list.stream().map(v -> {
            double nx = dir.x * v.z + vecX.x * v.x + -vecZ.x * v.y * (double)cosY;
            double ny = dir.y * v.z + vecX.y * v.x + -v.y * (double)sinY;
            double nz = dir.z * v.z + vecX.z * v.x + -vecZ.z * v.y * (double)cosY;
            return new Vec3(nx, ny, nz);
        });
    }

    public static Stream<Vec3> relativePointsToRotations(Entity entity, List<Vec3> list) {
        return LimaCoreMath.relativePointsToRotations(entity.getViewXRot(1.0f), entity.getViewYRot(1.0f), list);
    }

    public static Vec3 createMotionVector(LivingEntity entity, double length) {
        return LimaCoreMath.createMotionVector(entity.getViewXRot(1.0f), entity.getViewYRot(1.0f), length);
    }

    public static Vec3 createMotionVector(LivingEntity entity, double length, double inaccuracy) {
        return LimaCoreMath.createMotionVector(entity.getViewXRot(1.0f), entity.getViewYRot(1.0f), length, inaccuracy);
    }

    public static Vec3 createMotionVector(Vector2f angles, double length) {
        return LimaCoreMath.createMotionVector(angles.x, angles.y, length);
    }

    public static Vec3 createMotionVector(Vector2f angles, double length, double inaccuracy) {
        return LimaCoreMath.createMotionVector(angles.x, angles.y, length, inaccuracy);
    }

    public static Vec3 createMotionVector(float xRot, float yRot, double length) {
        float xRotRad = -LimaCoreMath.toRad(xRot);
        float yRotRad = -LimaCoreMath.toRad(yRot) - (float)Math.PI;
        float cosY = Mth.cos((float)yRotRad);
        float sinY = Mth.sin((float)yRotRad);
        float cosX = -Mth.cos((float)xRotRad);
        float sinX = Mth.sin((float)xRotRad);
        return new Vec3((double)(sinY * cosX) * length, (double)sinX * length, (double)(cosY * cosX) * length);
    }

    public static Vec3 createMotionVector(float xRot, float yRot, double length, double inaccuracy) {
        float xRotRad = -LimaCoreMath.toRad(xRot);
        float yRotRad = -LimaCoreMath.toRad(yRot) - (float)Math.PI;
        float cosY = Mth.cos((float)yRotRad);
        float sinY = Mth.sin((float)yRotRad);
        float cosX = -Mth.cos((float)xRotRad);
        float sinX = Mth.sin((float)xRotRad);
        return new Vec3(((double)(sinY * cosX) + LimaCoreMath.triangle(0.0, inaccuracy *= 0.0172275)) * length, ((double)sinX + LimaCoreMath.triangle(0.0, inaccuracy)) * length, ((double)(cosY * cosX) + LimaCoreMath.triangle(0.0, inaccuracy)) * length);
    }

    public static float getXRot(Vec3 direction) {
        return LimaCoreMath.toDeg(-Mth.atan2((double)direction.y(), (double)LimaCoreMath.vec2Length(direction)));
    }

    public static float getYRot(Vec3 direction) {
        return LimaCoreMath.toDeg(Mth.atan2((double)direction.z(), (double)direction.x())) - 90.0f;
    }

    public static Vector2f xyRotBetweenPoints(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        float xRot = LimaCoreMath.toDeg(-Mth.atan2((double)dy, (double)LimaCoreMath.vec2Length(dx, dz)));
        float yRot = LimaCoreMath.toDeg(Mth.atan2((double)dz, (double)dx)) - 90.0f;
        return new Vector2f(xRot, yRot);
    }

    public static Vector2f xyRotBetweenPoints(Vec3 a, Vec3 b) {
        return LimaCoreMath.xyRotBetweenPoints(a.x, a.y, a.z, b.x, b.y, b.z);
    }

    public static Vector3f xUnitVec() {
        return new Vector3f(1.0f, 0.0f, 0.0f);
    }

    public static Vector3f yUnitVec() {
        return new Vector3f(0.0f, 1.0f, 0.0f);
    }

    public static Vector3f zUnitVec() {
        return new Vector3f(0.0f, 0.0f, 1.0f);
    }

    public static Vector3f unitVecForAxis(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> LimaCoreMath.xUnitVec();
            case Direction.Axis.Y -> LimaCoreMath.yUnitVec();
            case Direction.Axis.Z -> LimaCoreMath.zUnitVec();
        };
    }
}

