/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.menu;

import java.util.function.Predicate;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.capability.itemhandler.LimaItemHandler;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.menu.slot.LimaHandlerSlot;
import liedge.limacore.menu.slot.RecipeOutputSlot;
import liedge.limacore.util.LimaItemUtil;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class BlockEntityMenu<CTX extends ItemHolderBlockEntity>
extends LimaMenu<CTX> {
    protected BlockEntityMenu(LimaMenuType<CTX, ?> type, int containerId, Inventory inventory, CTX menuContext) {
        super(type, containerId, inventory, menuContext);
    }

    protected void addSlot(BlockContentsType contentsType, int handlerIndex, int x, int y) {
        this.addSlot((Slot)new LimaHandlerSlot(this.getInventory(contentsType), handlerIndex, x, y));
    }

    protected void addSlot(BlockContentsType contentsType, int handlerIndex, int x, int y, Predicate<ItemStack> quickTransferPredicate) {
        this.addSlot((Slot)new LimaHandlerSlot(this.getInventory(contentsType), handlerIndex, x, y, true, quickTransferPredicate));
    }

    protected void addSlotsGrid(BlockContentsType contentsType, int indexStart, int x, int y, int columns, int rows) {
        this.addSlotsGrid(this.getInventory(contentsType), indexStart, x, y, columns, rows, LimaHandlerSlot::new);
    }

    @Override
    protected void addSlotsGrid(BlockContentsType contentsType, int indexStart, int x, int y, int columns, int rows, Predicate<ItemStack> quickTransferPredicate) {
        this.addSlotsGrid(this.getInventory(contentsType), indexStart, x, y, columns, rows, (? super T ctr, int slot, int sx, int sy) -> new LimaHandlerSlot((IItemHandlerModifiable)ctr, slot, sx, sy, true, quickTransferPredicate));
    }

    protected void addOutputSlot(int handlerIndex, int x, int y) {
        this.addSlot((Slot)new LimaHandlerSlot(this.getInventory(BlockContentsType.OUTPUT), handlerIndex, x, y, false, LimaItemUtil.ALWAYS_FALSE));
    }

    protected void addOutputSlotsGrid(int indexStart, int x, int y, int columns, int rows) {
        this.addSlotsGrid(this.getInventory(BlockContentsType.OUTPUT), indexStart, x, y, columns, rows, (? super T ctr, int slot, int sx, int sy) -> new LimaHandlerSlot((IItemHandlerModifiable)ctr, slot, sx, sy, false, LimaItemUtil.ALWAYS_FALSE));
    }

    protected void addRecipeOutputSlot(int handlerIndex, int x, int y, RecipeType<?> recipeType) {
        this.addSlot((Slot)new RecipeOutputSlot((IItemHandlerModifiable)this.getInventory(BlockContentsType.OUTPUT), handlerIndex, x, y, this.playerInventory.player, recipeType));
    }

    protected void addRecipeOutputSlot(int handlerIndex, int x, int y, Holder<RecipeType<?>> holder) {
        this.addRecipeOutputSlot(handlerIndex, x, y, (RecipeType)holder.value());
    }

    protected void addRecipeOutputSlotsGrid(int indexStart, int x, int y, int columns, int rows, RecipeType<?> recipeType) {
        this.addSlotsGrid(this.getInventory(BlockContentsType.OUTPUT), indexStart, x, y, columns, rows, (? super T ctr, int slot, int sx, int sy) -> new RecipeOutputSlot((IItemHandlerModifiable)ctr, slot, sx, sy, this.playerInventory.player, recipeType));
    }

    protected void addRecipeOutputSlotsGrid(int indexStart, int x, int y, int columns, int rows, Holder<RecipeType<?>> holder) {
        this.addRecipeOutputSlotsGrid(indexStart, x, y, columns, rows, (RecipeType)holder.value());
    }

    private LimaItemHandler getInventory(BlockContentsType contentsType) {
        return ((ItemHolderBlockEntity)this.menuContext).getItemHandlerOrThrow(contentsType);
    }
}

