/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.menu;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import liedge.limacore.LimaCore;
import liedge.limacore.capability.fluid.LimaFluidHandler;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.menu.slot.LimaFluidSlot;
import liedge.limacore.menu.slot.LimaHandlerSlot;
import liedge.limacore.menu.slot.RecipeOutputSlot;
import liedge.limacore.network.IndexedStreamData;
import liedge.limacore.network.NetworkSerializer;
import liedge.limacore.network.packet.ClientboundMenuDataWatcherPacket;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.limacore.util.LimaCoreUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.ApiStatus;

public abstract class LimaMenu<CTX>
extends AbstractContainerMenu
implements DataWatcherHolder {
    public static final int DEFAULT_INV_X = 8;
    public static final int DEFAULT_INV_Y = 84;
    public static final int DEFAULT_HOTBAR_Y = 142;
    public static final int DEFAULT_INV_HOTBAR_OFFSET = 58;
    private final LimaMenuType<CTX, ?> type;
    protected final Inventory playerInventory;
    protected final CTX menuContext;
    private final List<LimaDataWatcher<?>> dataWatchers;
    private final Int2ObjectMap<EventHandler<?>> buttonEventHandlers;
    protected final List<LimaFluidSlot> fluidSlots;
    private boolean firstTick = true;
    protected int inventoryStart;
    protected int hotbarStart;

    protected LimaMenu(LimaMenuType<CTX, ?> type, int containerId, Inventory inventory, CTX menuContext) {
        super(type, containerId);
        this.type = type;
        this.menuContext = menuContext;
        this.playerInventory = inventory;
        this.dataWatchers = this.createDataWatchers();
        this.fluidSlots = new ObjectArrayList();
        EventHandlerBuilder handlerBuilder = new EventHandlerBuilder();
        this.defineButtonEventHandlers(handlerBuilder);
        this.buttonEventHandlers = handlerBuilder.map != null ? Int2ObjectMaps.unmodifiable(handlerBuilder.map) : Int2ObjectMaps.emptyMap();
    }

    @Override
    public final List<LimaDataWatcher<?>> getDataWatchers() {
        return this.dataWatchers;
    }

    @Override
    public void sendDataWatcherPacket(List<IndexedStreamData<?>> streamData) {
        this.getServerUser().connection.send((CustomPacketPayload)new ClientboundMenuDataWatcherPacket(streamData, this.containerId));
    }

    public boolean stillValid(Player player) {
        return this.type.canPlayerKeepUsing(this.menuContext, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            if (!this.quickMoveInternal(index, stack1)) {
                return ItemStack.EMPTY;
            }
            if (slot instanceof RecipeOutputSlot) {
                RecipeOutputSlot recipeSlot = (RecipeOutputSlot)slot;
                recipeSlot.onQuickCraft(stack1, stack);
            }
            if (stack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
                if (slot instanceof LimaHandlerSlot) {
                    LimaHandlerSlot limaSlot = (LimaHandlerSlot)slot;
                    limaSlot.setBaseContainerChanged();
                }
            }
        }
        return stack;
    }

    public final void broadcastChanges() {
        super.broadcastChanges();
        if (this.firstTick) {
            this.forceSyncDataWatchers();
            this.firstTick = false;
        }
        this.tickDataWatchers();
    }

    protected void defineButtonEventHandlers(EventHandlerBuilder builder) {
    }

    public CTX menuContext() {
        return this.menuContext;
    }

    public Level level() {
        return this.playerInventory.player.level();
    }

    public List<LimaFluidSlot> getFluidSlots() {
        return this.fluidSlots;
    }

    public void fluidSlotClicked(ServerPlayer sender, int slotIndex, LimaFluidSlot.ClickAction action) {
        Object object = this.getCarried().getCapability(Capabilities.FluidHandler.ITEM);
        if (object instanceof IFluidHandlerItem) {
            IFluidHandlerItem itemFluids = (IFluidHandlerItem)object;
            LimaFluidSlot slot = this.getFluidSlots().get(slotIndex);
            LimaFluidHandler menuFluids = slot.fluidHandler();
            int capacity = slot.getCapacity();
            if (action == LimaFluidSlot.ClickAction.FILL) {
                FluidStack sourceFluid = itemFluids.drain(capacity, IFluidHandler.FluidAction.SIMULATE);
                if (!slot.mayPlace(sourceFluid)) {
                    return;
                }
                int accepted = menuFluids.fillTank(slot.tank(), sourceFluid, IFluidHandler.FluidAction.SIMULATE, true);
                if (accepted == 0) {
                    return;
                }
                sourceFluid = itemFluids.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
                accepted = menuFluids.fillTank(slot.tank(), sourceFluid, IFluidHandler.FluidAction.EXECUTE, true);
                if (accepted > 0) {
                    this.sendSoundToPlayer(sender, SoundEvents.BUCKET_EMPTY, 1.0f, 1.0f);
                    this.setCarried(itemFluids.getContainer());
                }
            } else {
                FluidStack sourceFluid = menuFluids.drainTank(slot.tank(), capacity, IFluidHandler.FluidAction.SIMULATE, true);
                int accepted = itemFluids.fill(sourceFluid, IFluidHandler.FluidAction.SIMULATE);
                if (accepted == 0) {
                    return;
                }
                sourceFluid = menuFluids.drainTank(slot.tank(), accepted, IFluidHandler.FluidAction.EXECUTE, true);
                accepted = itemFluids.fill(sourceFluid, IFluidHandler.FluidAction.EXECUTE);
                if (accepted > 0) {
                    this.sendSoundToPlayer(sender, SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
                    this.setCarried(itemFluids.getContainer());
                }
            }
        }
    }

    public ServerPlayer getServerUser() {
        return LimaCoreUtil.castOrThrow(ServerPlayer.class, (Object)this.playerInventory.player, "Attempted to access server menu user on client.");
    }

    public void sendSoundToPlayer(ServerPlayer player, Holder<SoundEvent> sound, float volume, float pitch) {
        Vec3 pos = player.position();
        ClientboundSoundPacket packet = new ClientboundSoundPacket(sound, SoundSource.PLAYERS, pos.x, pos.y, pos.z, volume, pitch, player.getRandom().nextLong());
        player.connection.send((Packet)packet);
    }

    public void sendSoundToPlayer(ServerPlayer player, SoundEvent sound, float volume, float pitch) {
        this.sendSoundToPlayer(player, (Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)sound), volume, pitch);
    }

    @ApiStatus.Internal
    public final void handleCustomButtonData(ServerPlayer sender, IndexedStreamData<?> streamData) {
        int buttonId = streamData.index();
        if (this.buttonEventHandlers.containsKey(buttonId)) {
            EventHandler handler = (EventHandler)this.buttonEventHandlers.get(buttonId);
            handler.tryHandle(sender, streamData);
        } else {
            LimaCore.LOGGER.warn("Received custom button data with invalid ID {}", (Object)buttonId);
        }
    }

    protected boolean quickMoveInternal(int index, ItemStack stack) {
        Object object;
        if (index < this.inventoryStart && (object = this.slots.get(index)) instanceof LimaHandlerSlot) {
            LimaHandlerSlot limaSlot = (LimaHandlerSlot)((Object)object);
            return this.quickMoveToAllInventory(stack, limaSlot.reverseQuickTransfer());
        }
        if (index >= this.inventoryStart) {
            return this.quickMoveToContainer(stack);
        }
        return false;
    }

    protected boolean quickMoveToContainer(ItemStack stack) {
        Object slotStack;
        LimaHandlerSlot limaSlot;
        int i;
        boolean result = false;
        if (stack.isStackable()) {
            for (i = 0; i < this.inventoryStart; ++i) {
                Object object = this.slots.get(i);
                if (object instanceof LimaHandlerSlot) {
                    limaSlot = (LimaHandlerSlot)((Object)object);
                    if (!limaSlot.canQuickTransfer(stack)) continue;
                    slotStack = limaSlot.getItem();
                    if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) {
                        int maxStackSize;
                        int n = slotStack.getCount() + stack.getCount();
                        if (n <= (maxStackSize = limaSlot.getMaxStackSize((ItemStack)slotStack))) {
                            stack.setCount(0);
                            slotStack.setCount(n);
                            limaSlot.setChanged();
                            limaSlot.setBaseContainerChanged();
                            result = true;
                        } else if (slotStack.getCount() < maxStackSize) {
                            stack.shrink(maxStackSize - slotStack.getCount());
                            slotStack.setCount(maxStackSize);
                            limaSlot.setChanged();
                            limaSlot.setBaseContainerChanged();
                            result = true;
                        }
                    }
                }
                if (stack.isEmpty()) break;
            }
        }
        if (!stack.isEmpty()) {
            for (i = 0; i < this.inventoryStart; ++i) {
                slotStack = this.slots.get(i);
                if (!(slotStack instanceof LimaHandlerSlot) || !(limaSlot = (LimaHandlerSlot)((Object)slotStack)).getItem().isEmpty() || !limaSlot.mayPlace(stack) || !limaSlot.canQuickTransfer(stack)) continue;
                int maxStackSize = limaSlot.getMaxStackSize(stack);
                limaSlot.setByPlayer(stack.split(Math.min(stack.getCount(), maxStackSize)));
                limaSlot.setChanged();
                limaSlot.setBaseContainerChanged();
                result = true;
                break;
            }
        }
        return result;
    }

    protected boolean quickMoveToInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, this.inventoryStart, this.inventoryStart + 27, reverse);
    }

    protected boolean quickMoveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, this.hotbarStart, this.hotbarStart + 9, reverse);
    }

    protected boolean quickMoveToAllInventory(ItemStack stack, boolean reverse) {
        if (reverse) {
            return this.quickMoveToHotbar(stack, true) || this.quickMoveToInventory(stack, true);
        }
        return this.quickMoveToInventory(stack, false) || this.quickMoveToHotbar(stack, false);
    }

    protected void runSlotsGrid(int startIndex, int xPos, int yPos, int columns, int rows, SlotPosConsumer consumer) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                consumer.accept(startIndex + (columns * y + x), xPos + x * 18, yPos + y * 18);
            }
        }
    }

    protected <T> void addSlotsGrid(T container, int startIndex, int xPos, int yPos, int columns, int rows, MenuSlotFactory<? super T> factory) {
        this.runSlotsGrid(startIndex, xPos, yPos, columns, rows, (i, sx, sy) -> this.addSlot(factory.createSlot((Object)container, i, sx, sy)));
    }

    protected void addPlayerInventory(int xPos, int yPos, MenuSlotFactory<Container> factory) {
        this.inventoryStart = this.slots.size();
        this.addSlotsGrid(this.playerInventory, 9, xPos, yPos, 9, 3, factory);
    }

    protected void addPlayerInventory(int xPos, int yPos) {
        this.addPlayerInventory(xPos, yPos, Slot::new);
    }

    protected void addPlayerHotbar(int xPos, int yPos, MenuSlotFactory<Container> factory) {
        this.hotbarStart = this.slots.size();
        this.addSlotsGrid(this.playerInventory, 0, xPos, yPos, 9, 1, factory);
    }

    protected void addPlayerHotbar(int xPos, int yPos) {
        this.addPlayerHotbar(xPos, yPos, Slot::new);
    }

    protected void addPlayerInventoryAndHotbar(int xPos, int yPos) {
        this.addPlayerInventory(xPos, yPos);
        this.addPlayerHotbar(xPos, yPos + 58);
    }

    protected void addDefaultPlayerInventoryAndHotbar() {
        this.addPlayerInventoryAndHotbar(8, 84);
    }

    protected void addFluidSlot(LimaFluidHandler handler, int tank, int x, int y, boolean allowInsert) {
        int index = this.fluidSlots.size();
        this.fluidSlots.add(new LimaFluidSlot(handler, index, tank, x, y, allowInsert));
    }

    protected void addFluidSlot(LimaFluidHandler handler, int tank, int x, int y) {
        this.addFluidSlot(handler, tank, x, y, true);
    }

    protected void addFluidSlotsGrid(LimaFluidHandler handler, int tankStart, int xPos, int yPos, int columns, int rows, boolean allowInsert) {
        this.runSlotsGrid(tankStart, xPos, yPos, columns, rows, (i, sx, sy) -> this.addFluidSlot(handler, i, sx, sy, allowInsert));
    }

    protected void addFluidSlotsGrid(LimaFluidHandler handler, int tankStart, int xPos, int yPos, int columns, int rows) {
        this.runSlotsGrid(tankStart, xPos, yPos, columns, rows, (i, sx, sy) -> this.addFluidSlot(handler, i, sx, sy, true));
    }

    protected static class EventHandlerBuilder {
        private Int2ObjectMap<EventHandler<?>> map;

        protected EventHandlerBuilder() {
        }

        public <T> void handleAction(int index, NetworkSerializer<T> serializer, BiConsumer<ServerPlayer, T> action) {
            if (this.map == null) {
                this.map = new Int2ObjectOpenHashMap();
            }
            LimaCollectionsUtil.putNoDuplicates(this.map, index, new EventHandler<T>(serializer, action));
        }

        public <T> void handleAction(int index, Supplier<? extends NetworkSerializer<T>> supplier, BiConsumer<ServerPlayer, T> action) {
            this.handleAction(index, supplier.get(), action);
        }

        public void handleUnitAction(int index, Consumer<ServerPlayer> action) {
            this.handleAction(index, (Supplier)LimaCoreNetworkSerializers.UNIT, (BiConsumer)(sender, $) -> action.accept((ServerPlayer)sender));
        }
    }

    private record EventHandler<T>(NetworkSerializer<T> serializer, BiConsumer<ServerPlayer, T> action) {
        private void tryHandle(ServerPlayer player, IndexedStreamData<?> streamData) {
            T data = streamData.tryCast(this.serializer);
            if (data != null) {
                this.action.accept(player, (ServerPlayer)data);
            }
        }
    }

    @FunctionalInterface
    public static interface SlotPosConsumer {
        public void accept(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface MenuSlotFactory<T> {
        public Slot createSlot(T var1, int var2, int var3, int var4);
    }
}

