/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.menu;

import java.util.Objects;
import liedge.limacore.LimaCore;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public interface LimaMenuProvider
extends MenuProvider {
    public static <CTX, M extends LimaMenu<CTX>> LimaMenuProvider create(final LimaMenuType<CTX, M> type, final CTX context, final @Nullable Component title, final boolean closeClientContainer) {
        return new LimaMenuProvider(){

            @Override
            public LimaMenuType<?, ?> getMenuType() {
                return type;
            }

            public CTX context() {
                return context;
            }

            @Override
            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return type.createMenu(containerId, inventory, context);
            }

            @Override
            public Component getDisplayName() {
                return title != null ? title : LimaMenuProvider.super.getDisplayName();
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return closeClientContainer;
            }
        };
    }

    public static <CTX, M extends LimaMenu<CTX>> LimaMenuProvider create(LimaMenuType<CTX, M> type, CTX context, @Nullable Component title) {
        return LimaMenuProvider.create(type, context, title, true);
    }

    public LimaMenuType<?, ?> getMenuType();

    public Object context();

    default public void openMenuScreen(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)this, net -> this.getMenuType().tryEncodeContext(this.context(), (RegistryFriendlyByteBuf)net));
        } else {
            LimaCore.LOGGER.warn("Tried to open menu screen of type '{}' on the client", (Object)LimaRegistryUtil.getNonNullRegistryId(this.getMenuType(), BuiltInRegistries.MENU));
        }
    }

    default public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return this.getMenuType().tryCreateMenu(containerId, inventory, this.context());
    }

    default public Component getDisplayName() {
        return Objects.requireNonNull(this.getMenuType().getDefaultTitle(), "Standalone menu types must have a default title.").translate();
    }
}

