/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.menu;

import liedge.limacore.lib.ModResources;
import liedge.limacore.lib.Translatable;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.util.LimaCoreUtil;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public abstract class LimaMenuType<CTX, M extends LimaMenu<CTX>>
extends MenuType<M> {
    private final Class<CTX> contextClass;
    private final MenuFactory<CTX, M> factory;
    @Nullable
    private final Translatable defaultTitle;

    public static Translatable defaultMenuTitle(ResourceLocation id) {
        return Translatable.standalone(ModResources.prefixedIdLangKey("container", id));
    }

    protected LimaMenuType(Class<CTX> contextClass, MenuFactory<CTX, M> factory, @Nullable Translatable defaultTitle) {
        super((containerId, inv) -> {
            throw new UnsupportedOperationException("Parameterless menu creation not supported. Use createMenu or tryCreateMenu");
        }, FeatureFlags.DEFAULT_FLAGS);
        this.contextClass = contextClass;
        this.factory = factory;
        this.defaultTitle = defaultTitle;
    }

    public Class<CTX> getContextClass() {
        return this.contextClass;
    }

    @Nullable
    public Translatable getDefaultTitle() {
        return this.defaultTitle;
    }

    public void tryEncodeContext(Object uncheckedContext, RegistryFriendlyByteBuf net) {
        CTX menuContext = this.checkContext(uncheckedContext);
        this.encodeContext(menuContext, net);
    }

    public abstract void encodeContext(CTX var1, RegistryFriendlyByteBuf var2);

    protected abstract CTX decodeContext(RegistryFriendlyByteBuf var1, Inventory var2);

    public abstract boolean canPlayerKeepUsing(CTX var1, Player var2);

    public M createMenu(int containerId, Inventory inventory, CTX menuContext) {
        return this.factory.createMenu(this, containerId, inventory, menuContext);
    }

    public M tryCreateMenu(int containerId, Inventory inventory, Object uncheckedContext) {
        return this.createMenu(containerId, inventory, this.checkContext(uncheckedContext));
    }

    protected CTX checkContext(Object uncheckedContext) {
        return LimaCoreUtil.castOrThrow(this.contextClass, uncheckedContext, () -> new IllegalArgumentException(String.format("Invalid context type '%s' for menu type '%s'", uncheckedContext.getClass().getSimpleName(), LimaRegistryUtil.getNonNullRegistryId(this, BuiltInRegistries.MENU))));
    }

    public final M create(int containerId, Inventory inventory) {
        throw new UnsupportedOperationException("Parameterless menu creation not supported. Use createMenu or tryCreateMenu");
    }

    public final M create(int containerId, Inventory inventory, RegistryFriendlyByteBuf net) {
        CTX menuContext = this.decodeContext(net, inventory);
        return this.factory.createMenu(this, containerId, inventory, menuContext);
    }

    @FunctionalInterface
    public static interface MenuFactory<CTX, M extends LimaMenu<CTX>> {
        public M createMenu(LimaMenuType<CTX, ?> var1, int var2, Inventory var3, CTX var4);
    }
}

