/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.menu.slot;

import java.util.function.Predicate;
import liedge.limacore.capability.itemhandler.LimaItemHandler;
import liedge.limacore.util.LimaItemUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;

public class LimaHandlerSlot
extends SlotItemHandler {
    private final boolean allowInsert;
    private final Predicate<ItemStack> quickTransferPredicate;

    public LimaHandlerSlot(IItemHandlerModifiable itemHandler, int handlerIndex, int xPos, int yPos, boolean allowInsert, Predicate<ItemStack> quickTransferPredicate) {
        super((IItemHandler)itemHandler, handlerIndex, xPos, yPos);
        this.allowInsert = allowInsert;
        this.quickTransferPredicate = quickTransferPredicate;
    }

    public LimaHandlerSlot(IItemHandlerModifiable itemHandler, int handlerIndex, int xPos, int yPos) {
        this(itemHandler, handlerIndex, xPos, yPos, true, LimaItemUtil.ALWAYS_TRUE);
    }

    public boolean reverseQuickTransfer() {
        return false;
    }

    public boolean canQuickTransfer(ItemStack stack) {
        return this.quickTransferPredicate.test(stack);
    }

    public boolean mayPlace(ItemStack stack) {
        return this.allowInsert && this.getItemHandler().isItemValid(this.index, stack);
    }

    public void setBaseContainerChanged() {
        IItemHandler iItemHandler = this.getItemHandler();
        if (iItemHandler instanceof LimaItemHandler) {
            LimaItemHandler limaHandler = (LimaItemHandler)iItemHandler;
            limaHandler.onContentsChanged(this.index);
        }
    }
}

