/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.mixin;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import liedge.limacore.event.DamageAttributeModifiersEvent;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import oshi.util.tuples.Pair;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private final List<Pair<Holder<Attribute>, AttributeModifier>> limacore$modifiers = new ObjectArrayList();

    @Inject(method={"hurt"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/neoforged/neoforge/common/damagesource/DamageContainer;getNewDamage()F", ordinal=0)})
    private void trueOnPreDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.limacore$modifiers.clear();
        NeoForge.EVENT_BUS.post((Event)new DamageAttributeModifiersEvent(source, amount, this.limacore$modifiers));
        LivingEntity thisEntity = (LivingEntity)this;
        for (Pair<Holder<Attribute>, AttributeModifier> pair : this.limacore$modifiers) {
            AttributeInstance instance = thisEntity.getAttribute((Holder)pair.getA());
            if (instance == null) continue;
            AttributeModifier mod = (AttributeModifier)pair.getB();
            instance.removeModifier(mod);
            instance.addTransientModifier(mod);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Ljava/util/Stack;pop()Ljava/lang/Object;", ordinal=1)})
    private void trueOnPostDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity thisEntity = (LivingEntity)this;
        for (Pair<Holder<Attribute>, AttributeModifier> pair : this.limacore$modifiers) {
            AttributeInstance instance = thisEntity.getAttribute((Holder)pair.getA());
            if (instance == null) continue;
            instance.removeModifier((AttributeModifier)pair.getB());
        }
    }
}

