/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.network.packet;

import liedge.limacore.menu.LimaMenu;
import liedge.limacore.network.packet.ServerboundBlockEntityDataRequestPacket;
import liedge.limacore.network.packet.ServerboundCustomMenuButtonPacket;
import liedge.limacore.network.packet.ServerboundFluidSlotClickPacket;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.util.LimaBlockUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelReader;

public final class LimaCoreServerPacketHandler {
    private LimaCoreServerPacketHandler() {
    }

    static void handleBlockDataRequestPacket(ServerboundBlockEntityDataRequestPacket packet, ServerPlayer sender) {
        DataWatcherHolder holder = LimaBlockUtil.getSafeBlockEntity((LevelReader)sender.level(), packet.blockPos(), DataWatcherHolder.class);
        if (holder != null) {
            holder.forceSyncDataWatchers();
        }
    }

    static void handleCustomMenuButtonPacket(ServerboundCustomMenuButtonPacket packet, ServerPlayer sender) {
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (abstractContainerMenu instanceof LimaMenu) {
            LimaMenu menu = (LimaMenu)abstractContainerMenu;
            if (menu.containerId == packet.containerId()) {
                menu.handleCustomButtonData(sender, packet.streamData());
            }
        }
    }

    static void handleFluidSlotClick(ServerboundFluidSlotClickPacket packet, ServerPlayer sender) {
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (abstractContainerMenu instanceof LimaMenu) {
            LimaMenu menu = (LimaMenu)abstractContainerMenu;
            if (menu.containerId == packet.containerId()) {
                menu.fluidSlotClicked(sender, packet.slotIndex(), packet.action());
            }
        }
    }
}

