/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.network.sync;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import liedge.limacore.network.IndexedStreamData;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.util.LimaCollectionsUtil;
import org.jetbrains.annotations.ApiStatus;

public interface DataWatcherHolder {
    public List<LimaDataWatcher<?>> getDataWatchers();

    @ApiStatus.OverrideOnly
    public void defineDataWatchers(DataWatcherCollector var1);

    @ApiStatus.OverrideOnly
    public void sendDataWatcherPacket(List<IndexedStreamData<?>> var1);

    @ApiStatus.Internal
    default public void receiveDataWatcherPacket(List<IndexedStreamData<?>> streamData) {
        List<LimaDataWatcher<?>> dataWatchers = this.getDataWatchers();
        for (IndexedStreamData<?> entry : streamData) {
            dataWatchers.get(entry.index()).readStreamData(entry);
        }
    }

    default public void forceSyncDataWatchers() {
        List<LimaDataWatcher<?>> dataWatchers = this.getDataWatchers();
        if (dataWatchers.isEmpty()) {
            return;
        }
        ObjectArrayList streamData = new ObjectArrayList();
        for (int index = 0; index < dataWatchers.size(); ++index) {
            streamData.add(dataWatchers.get(index).writeStreamData(index));
        }
        this.sendDataWatcherPacket((List<IndexedStreamData<?>>)streamData);
    }

    default public void tickDataWatchers() {
        List<LimaDataWatcher<?>> dataWatchers = this.getDataWatchers();
        ObjectArrayList streamData = null;
        for (int index = 0; index < dataWatchers.size(); ++index) {
            LimaDataWatcher<?> watcher = dataWatchers.get(index);
            if (!watcher.tick()) continue;
            if (streamData == null) {
                streamData = new ObjectArrayList();
            }
            streamData.add(watcher.writeStreamData(index));
        }
        if (streamData != null) {
            this.sendDataWatcherPacket((List<IndexedStreamData<?>>)streamData);
        }
    }

    default public List<LimaDataWatcher<?>> createDataWatchers() {
        ObjectArrayList list = new ObjectArrayList();
        this.defineDataWatchers(arg_0 -> DataWatcherHolder.lambda$createDataWatchers$0((ObjectList)list, arg_0));
        return ObjectLists.unmodifiable((ObjectList)list);
    }

    private static /* synthetic */ int lambda$createDataWatchers$0(ObjectList list, LimaDataWatcher watcher) {
        return LimaCollectionsUtil.addAndGetIndex(list, watcher);
    }

    @FunctionalInterface
    public static interface DataWatcherCollector {
        public int register(LimaDataWatcher<?> var1);
    }
}

