/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.network.sync;

import liedge.limacore.network.IndexedStreamData;
import liedge.limacore.network.NetworkSerializer;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.ManualDataWatcher;
import org.jetbrains.annotations.ApiStatus;

public abstract sealed class LimaDataWatcher<T>
permits ManualDataWatcher, AutomaticDataWatcher {
    private final NetworkSerializer<T> serializer;
    private boolean changed;

    protected LimaDataWatcher(NetworkSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected abstract T getCurrentData();

    protected abstract void setCurrentData(T var1);

    @ApiStatus.Internal
    protected boolean tick() {
        if (this.isChanged()) {
            this.setChanged(false);
            return true;
        }
        return false;
    }

    IndexedStreamData<T> writeStreamData(int index) {
        return new IndexedStreamData<T>(index, this.serializer, this.getCurrentData());
    }

    void readStreamData(IndexedStreamData<?> streamData) {
        T data = streamData.tryCast(this.serializer);
        if (data != null) {
            this.setCurrentData(data);
        }
    }
}

