/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.network.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import liedge.limacore.network.NetworkSerializer;
import liedge.limacore.network.sync.LimaDataWatcher;

public final class ManualDataWatcher<T>
extends LimaDataWatcher<T> {
    private final Supplier<T> getter;
    private final Consumer<T> setter;

    public static <T> LimaDataWatcher<T> manuallyTrack(NetworkSerializer<T> serializer, Supplier<T> getter, Consumer<T> setter) {
        return new ManualDataWatcher<T>(serializer, getter, setter);
    }

    public static <T> LimaDataWatcher<T> manuallyTrack(Supplier<? extends NetworkSerializer<T>> supplier, Supplier<T> getter, Consumer<T> setter) {
        return new ManualDataWatcher<T>(supplier.get(), getter, setter);
    }

    private ManualDataWatcher(NetworkSerializer<T> serializer, Supplier<T> getter, Consumer<T> setter) {
        super(serializer);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected T getCurrentData() {
        return this.getter.get();
    }

    @Override
    protected void setCurrentData(T currentData) {
        this.setter.accept(currentData);
    }
}

