/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import liedge.limacore.recipe.LimaRecipeInput;
import liedge.limacore.recipe.ingredient.DeterministicIngredient;
import liedge.limacore.recipe.result.ItemResult;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public abstract class LimaCustomRecipe<T extends LimaRecipeInput>
implements Recipe<T> {
    public static final String EMPTY_GROUP = "";
    public static final MapCodec<String> GROUP_MAP_CODEC = Codec.STRING.optionalFieldOf("group", (Object)"");
    private final List<SizedIngredient> itemIngredients;
    private final List<SizedFluidIngredient> fluidIngredients;
    private final List<ItemResult> itemResults;
    private final List<FluidStack> fluidResults;

    public static <R extends LimaCustomRecipe<?>> DataResult<R> checkNotEmpty(R recipe) {
        if (recipe.getItemIngredients().isEmpty() && recipe.getFluidIngredients().isEmpty()) {
            return DataResult.error(() -> "Recipe has no item or fluid ingredients.");
        }
        if (recipe.getItemResults().isEmpty() && recipe.getFluidResults().isEmpty()) {
            return DataResult.error(() -> "Recipe has no item or fluid output results.");
        }
        if (!recipe.getItemResults().isEmpty() && recipe.getItemResults().stream().noneMatch(ItemResult::requiredOutput)) {
            return DataResult.error(() -> "Recipe must have at least 1 required item output.");
        }
        return DataResult.success(recipe);
    }

    protected LimaCustomRecipe(List<SizedIngredient> itemIngredients, List<SizedFluidIngredient> fluidIngredients, List<ItemResult> itemResults, List<FluidStack> fluidResults) {
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        this.itemResults = itemResults;
        this.fluidResults = fluidResults;
    }

    protected LimaCustomRecipe(List<SizedIngredient> itemIngredients, List<ItemResult> itemResults) {
        this(itemIngredients, List.of(), itemResults, List.of());
    }

    public List<SizedIngredient> getItemIngredients() {
        return this.itemIngredients;
    }

    public List<SizedFluidIngredient> getFluidIngredients() {
        return this.fluidIngredients;
    }

    public SizedIngredient getItemIngredient(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.itemIngredients.size(), (String)"Item Ingredient");
        return this.itemIngredients.get(index);
    }

    public SizedFluidIngredient getFluidIngredient(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.fluidIngredients.size(), (String)"Fluid Ingredient");
        return this.fluidIngredients.get(index);
    }

    public List<ItemResult> getItemResults() {
        return this.itemResults;
    }

    public ItemResult getItemResult(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.itemResults.size(), (String)"Item Result");
        return this.itemResults.get(index);
    }

    public ItemResult getFirstItemResult() {
        Preconditions.checkState((!this.itemResults.isEmpty() ? 1 : 0) != 0, (Object)"Recipe has no item results.");
        return this.itemResults.getFirst();
    }

    public List<ItemStack> generateItemResults(T input, HolderLookup.Provider registries, RandomSource random) {
        return (List)this.itemResults.stream().map(r -> r.generateResult(random)).filter(s -> !s.isEmpty()).collect(LimaStreamsUtil.toObjectList());
    }

    public List<ItemStack> getPossibleItemResults() {
        return (List)this.itemResults.stream().map(ItemResult::getMaximumResult).collect(LimaStreamsUtil.toObjectList());
    }

    public List<FluidStack> getFluidResults() {
        return this.fluidResults;
    }

    public FluidStack getFluidResult(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.fluidResults.size(), (String)"Fluid results");
        return this.fluidResults.get(index);
    }

    public FluidStack getFirstFluidResult() {
        Preconditions.checkState((!this.fluidResults.isEmpty() ? 1 : 0) != 0, (Object)"Recipe has no fluid results.");
        return this.fluidResults.getFirst();
    }

    public List<FluidStack> generateFluidResults(T input, HolderLookup.Provider registries) {
        return (List)this.fluidResults.stream().map(FluidStack::copy).collect(LimaStreamsUtil.toObjectList());
    }

    private boolean shouldConsumeItemIngredient(Ingredient root, RandomSource random) {
        ICustomIngredient iCustomIngredient = root.getCustomIngredient();
        if (iCustomIngredient instanceof DeterministicIngredient) {
            DeterministicIngredient ingredient = (DeterministicIngredient)iCustomIngredient;
            return ingredient.shouldConsume(random);
        }
        return true;
    }

    private boolean shouldConsumeFluidIngredient(FluidIngredient root, RandomSource random) {
        if (root instanceof DeterministicIngredient) {
            DeterministicIngredient ingredient = (DeterministicIngredient)root;
            return ingredient.shouldConsume(random);
        }
        return true;
    }

    public void consumeItemIngredients(T input, RandomSource random) {
        for (SizedIngredient sizedIngredient : this.itemIngredients) {
            ItemStack extracted;
            int remaining = sizedIngredient.count();
            Ingredient root = sizedIngredient.ingredient();
            if (!this.shouldConsumeItemIngredient(root, random)) continue;
            for (int slot = 0; !(slot >= input.size() || root.test(input.getItem(slot)) && (remaining -= (extracted = input.extractItem(slot, remaining, false)).getCount()) == 0); ++slot) {
            }
        }
    }

    public void consumeFluidIngredients(T input, RandomSource random) {
        for (SizedFluidIngredient sizedIngredient : this.fluidIngredients) {
            FluidStack extracted;
            int remaining = sizedIngredient.amount();
            FluidIngredient root = sizedIngredient.ingredient();
            if (!this.shouldConsumeFluidIngredient(root, random)) continue;
            for (int tank = 0; !(tank >= input.tanks() || root.test(input.getFluid(tank)) && (remaining -= (extracted = input.extractFluid(tank, remaining, IFluidHandler.FluidAction.EXECUTE)).getAmount()) == 0); ++tank) {
            }
        }
    }

    private boolean checkItemInputs(T input) {
        if (!input.checkItemInputSize(this.itemIngredients)) {
            return false;
        }
        int[] removalTracker = new int[input.size()];
        for (SizedIngredient sizedIngredient : this.itemIngredients) {
            int stillNeeded = sizedIngredient.count();
            Ingredient root = sizedIngredient.ingredient();
            for (int slot = 0; slot < input.size(); ++slot) {
                int toExtract;
                if (!root.test(input.getItem(slot)) || (toExtract = Math.max(0, stillNeeded - removalTracker[slot])) <= 0) continue;
                ItemStack extracted = input.extractItem(slot, toExtract, true);
                int n = slot;
                removalTracker[n] = removalTracker[n] + extracted.getCount();
                if ((stillNeeded -= extracted.getCount()) == 0) break;
            }
            if (stillNeeded <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean checkFluidInputs(T input) {
        if (!input.checkFluidInputSize(this.fluidIngredients)) {
            return false;
        }
        int[] removalTracker = new int[input.tanks()];
        for (SizedFluidIngredient sizedIngredient : this.fluidIngredients) {
            int stillNeeded = sizedIngredient.amount();
            FluidIngredient root = sizedIngredient.ingredient();
            for (int tank = 0; tank < input.tanks(); ++tank) {
                int toDrain;
                if (!root.test(input.getFluid(tank)) || (toDrain = Math.max(0, stillNeeded - removalTracker[tank])) <= 0) continue;
                FluidStack extracted = input.extractFluid(tank, toDrain, IFluidHandler.FluidAction.SIMULATE);
                int n = tank;
                removalTracker[n] = removalTracker[n] + extracted.getAmount();
                if ((stillNeeded -= extracted.getAmount()) == 0) break;
            }
            if (stillNeeded <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean matches(T input, Level level) {
        return this.checkItemInputs(input) && this.checkFluidInputs(input);
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean isIncomplete() {
        return this.itemIngredients.isEmpty() || this.itemIngredients.stream().map(SizedIngredient::ingredient).anyMatch(Ingredient::hasNoItems);
    }

    @Deprecated
    public NonNullList<Ingredient> getIngredients() {
        return super.getIngredients();
    }

    @Deprecated
    public ItemStack assemble(T input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @Deprecated
    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @FunctionalInterface
    public static interface RecipeFactory<R extends LimaCustomRecipe<?>>
    extends Function4<List<SizedIngredient>, List<SizedFluidIngredient>, List<ItemResult>, List<FluidStack>, R> {
        public R create(List<SizedIngredient> var1, List<SizedFluidIngredient> var2, List<ItemResult> var3, List<FluidStack> var4);

        default public R apply(List<SizedIngredient> ingredients, List<SizedFluidIngredient> fluidIngredients, List<ItemResult> itemResults, List<FluidStack> fluidStacks) {
            return this.create(ingredients, fluidIngredients, itemResults, fluidStacks);
        }
    }
}

