/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe;

import java.util.List;
import liedge.limacore.capability.fluid.LimaFluidHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public interface LimaRecipeInput
extends RecipeInput {
    public static LimaRecipeInput create(@Nullable IItemHandler itemContainer, @Nullable LimaFluidHandler fluidContainer) {
        return new SimpleWrapper(itemContainer, fluidContainer);
    }

    public ItemStack extractItem(int var1, int var2, boolean var3);

    public FluidStack extractFluid(int var1, int var2, IFluidHandler.FluidAction var3);

    public FluidStack getFluid(int var1);

    public int tanks();

    default public boolean isEmpty() {
        return this.areItemsEmpty() && this.areFluidsEmpty();
    }

    default public boolean areItemsEmpty() {
        return super.isEmpty();
    }

    default public boolean areFluidsEmpty() {
        for (int i = 0; i < this.tanks(); ++i) {
            if (this.getFluid(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public boolean checkItemInputSize(List<SizedIngredient> itemIngredients) {
        return itemIngredients.isEmpty() || itemIngredients.size() <= this.size() && !this.isEmpty();
    }

    default public boolean checkFluidInputSize(List<SizedFluidIngredient> fluidIngredients) {
        return fluidIngredients.isEmpty() || fluidIngredients.size() <= this.tanks() && !this.areFluidsEmpty();
    }

    public record SimpleWrapper(@Nullable IItemHandler itemContainer, @Nullable LimaFluidHandler fluidContainer) implements ContainerWrapper
    {
    }

    public static interface ContainerWrapper
    extends LimaRecipeInput {
        @Nullable
        public IItemHandler itemContainer();

        @Nullable
        public LimaFluidHandler fluidContainer();

        @Override
        default public ItemStack extractItem(int slot, int count, boolean simulate) {
            IItemHandler container = this.itemContainer();
            return container != null ? container.extractItem(slot, count, simulate) : ItemStack.EMPTY;
        }

        default public ItemStack getItem(int index) {
            IItemHandler container = this.itemContainer();
            return container != null ? container.getStackInSlot(index) : ItemStack.EMPTY;
        }

        default public int size() {
            IItemHandler container = this.itemContainer();
            return container != null ? container.getSlots() : 0;
        }

        @Override
        default public FluidStack extractFluid(int tank, int amount, IFluidHandler.FluidAction action) {
            LimaFluidHandler container = this.fluidContainer();
            return container != null ? container.drainTank(tank, amount, action, true) : FluidStack.EMPTY;
        }

        @Override
        default public FluidStack getFluid(int tank) {
            LimaFluidHandler container = this.fluidContainer();
            return container != null ? container.getFluidInTank(tank) : FluidStack.EMPTY;
        }

        @Override
        default public int tanks() {
            LimaFluidHandler container = this.fluidContainer();
            return container != null ? container.getTanks() : 0;
        }
    }
}

