/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe.ingredient;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import liedge.limacore.recipe.ingredient.DeterministicIngredient;
import liedge.limacore.registry.game.LimaCoreIngredientTypes;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredientType;

public final class DeterministicFluidIngredient
extends FluidIngredient
implements DeterministicIngredient<FluidIngredient> {
    public static final MapCodec<DeterministicFluidIngredient> CODEC = DeterministicIngredient.codec(FluidIngredient.CODEC, DeterministicFluidIngredient::new);
    private final FluidIngredient child;
    private final float consumeChance;

    public DeterministicFluidIngredient(FluidIngredient child, float consumeChance) {
        this.child = child;
        this.consumeChance = consumeChance;
    }

    @Override
    public FluidIngredient child() {
        return this.child;
    }

    @Override
    public float consumeChance() {
        return this.consumeChance;
    }

    public boolean test(FluidStack fluidStack) {
        return this.child.test(fluidStack);
    }

    protected Stream<FluidStack> generateStacks() {
        return Arrays.stream(this.child.getStacks());
    }

    public boolean isSimple() {
        return false;
    }

    public FluidIngredientType<?> getType() {
        return (FluidIngredientType)LimaCoreIngredientTypes.DETERMINISTIC_FLUID.get();
    }

    public int hashCode() {
        return Objects.hash(this.child, Float.valueOf(this.consumeChance));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeterministicFluidIngredient)) {
            return false;
        }
        DeterministicFluidIngredient other = (DeterministicFluidIngredient)obj;
        return this.child.equals((Object)other.child) && this.consumeChance == other.consumeChance;
    }
}

