/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe.ingredient;

import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.stream.Stream;
import liedge.limacore.recipe.ingredient.DeterministicIngredient;
import liedge.limacore.registry.game.LimaCoreIngredientTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public final class DeterministicItemIngredient
extends Record
implements ICustomIngredient,
DeterministicIngredient<Ingredient> {
    private final Ingredient child;
    private final float consumeChance;
    public static final MapCodec<DeterministicItemIngredient> CODEC = DeterministicIngredient.codec(Ingredient.CODEC_NONEMPTY, DeterministicItemIngredient::new);

    public DeterministicItemIngredient(Ingredient child, float consumeChance) {
        this.child = child;
        this.consumeChance = consumeChance;
    }

    public static Ingredient of(Ingredient child, float consumeChance) {
        return new Ingredient((ICustomIngredient)new DeterministicItemIngredient(child, consumeChance));
    }

    public boolean test(ItemStack stack) {
        return this.child.test(stack);
    }

    public Stream<ItemStack> getItems() {
        return Arrays.stream(this.child.getItems());
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)LimaCoreIngredientTypes.DETERMINISTIC_ITEM.get();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{DeterministicItemIngredient.class, "child;consumeChance", "child", "consumeChance"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DeterministicItemIngredient.class, "child;consumeChance", "child", "consumeChance"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DeterministicItemIngredient.class, "child;consumeChance", "child", "consumeChance"}, this, o);
    }

    @Override
    public Ingredient child() {
        return this.child;
    }

    @Override
    public float consumeChance() {
        return this.consumeChance;
    }
}

