/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe.result;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import liedge.limacore.data.EmptyFieldMapCodec;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.network.LimaStreamCodecs;
import liedge.limacore.recipe.result.ConstantItemResult;
import liedge.limacore.recipe.result.ItemResultType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface ItemResult {
    public static final String MAP_CODEC_KEY = "item_results";
    public static final MapCodec<Boolean> REQUIRED_FIELD = Codec.BOOL.optionalFieldOf("required", (Object)true);
    public static final Codec<ItemResult> CODEC = ItemResultType.CODEC.dispatchWithInline(ConstantItemResult.class, ConstantItemResult.INLINE_CODEC, ItemResult::getType, ItemResultType::getCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemResult> STREAM_CODEC = ItemResultType.STREAM_CODEC.dispatch(ItemResult::getType, ItemResultType::getStreamCodec);
    public static final MapCodec<List<ItemResult>> LIST_UNIT_MAP_CODEC = EmptyFieldMapCodec.emptyListField("item_results");
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemResult>> LIST_UNIT_STREAM_CODEC = StreamCodec.unit(List.of());
    public static final Comparator<ItemResult> REQUIRED_FIRST = Comparator.comparing(ItemResult::requiredOutput).reversed();

    public static MapCodec<List<ItemResult>> listMapCodec(int min, int max) {
        UnaryOperator sortingFunction = unsorted -> {
            if (unsorted.size() < 2 || unsorted.stream().allMatch(ItemResult::requiredOutput)) {
                return unsorted;
            }
            ObjectArrayList sorted = new ObjectArrayList((Collection)unsorted);
            sorted.sort(REQUIRED_FIRST);
            return ObjectLists.unmodifiable((ObjectList)sorted);
        };
        return LimaCoreCodecs.autoOptionalListField(CODEC, MAP_CODEC_KEY, min, max).xmap((Function)sortingFunction, (Function)sortingFunction);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, List<ItemResult>> listStreamCodec(int min, int max) {
        return STREAM_CODEC.apply(LimaStreamCodecs.asClampedList(min, max));
    }

    public boolean requiredOutput();

    public Item getItem();

    public ItemStack getMaximumResult();

    public ItemStack generateResult(RandomSource var1);

    public ItemResultType getType();

    default public ItemStack getGuiPreviewResult() {
        return this.getMaximumResult();
    }

    default public float resultChance() {
        return 1.0f;
    }

    default public int minimumCount() {
        return this.maximumCount();
    }

    default public int maximumCount() {
        return this.getMaximumResult().getCount();
    }
}

