/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe.result;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.recipe.result.ItemResult;
import liedge.limacore.recipe.result.ItemResultType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record RandomChanceItemResult(ItemStack item, float resultChance, boolean requiredOutput) implements ItemResult
{
    static final MapCodec<RandomChanceItemResult> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(RandomChanceItemResult::item), (App)LimaCoreCodecs.floatOpenRange(0.0f, 1.0f).fieldOf("chance").forGetter(RandomChanceItemResult::resultChance), (App)REQUIRED_FIELD.forGetter(RandomChanceItemResult::requiredOutput)).apply((Applicative)instance, RandomChanceItemResult::new));
    static final StreamCodec<RegistryFriendlyByteBuf, RandomChanceItemResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RandomChanceItemResult::item, (StreamCodec)ByteBufCodecs.FLOAT, RandomChanceItemResult::resultChance, (StreamCodec)ByteBufCodecs.BOOL, RandomChanceItemResult::requiredOutput, RandomChanceItemResult::new);

    @Override
    public Item getItem() {
        return this.item.getItem();
    }

    @Override
    public ItemStack getMaximumResult() {
        return this.item;
    }

    @Override
    public ItemStack generateResult(RandomSource random) {
        return random.nextFloat() < this.resultChance ? this.item.copy() : ItemStack.EMPTY;
    }

    @Override
    public ItemResultType getType() {
        return ItemResultType.RANDOM_CHANCE;
    }
}

