/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.recipe.result;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.network.LimaStreamCodecs;
import liedge.limacore.recipe.result.ItemResult;
import liedge.limacore.recipe.result.ItemResultType;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class VariableCountItemResult
implements ItemResult {
    static final MapCodec<VariableCountItemResult> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("item").forGetter(o -> o.holder), (App)LimaCoreCodecs.ITEM_COMPONENTS_FIELD.forGetter(o -> o.components), (App)Codec.intRange((int)0, (int)99).fieldOf("min_count").forGetter(o -> o.minCount), (App)Codec.intRange((int)0, (int)99).fieldOf("max_count").forGetter(o -> o.maxCount), (App)REQUIRED_FIELD.forGetter(o -> o.required)).apply((Applicative)instance, VariableCountItemResult::new)).validate(VariableCountItemResult::validate);
    static final StreamCodec<RegistryFriendlyByteBuf, VariableCountItemResult> STREAM_CODEC = StreamCodec.composite(LimaStreamCodecs.ITEM_HOLDER, o -> o.holder, (StreamCodec)DataComponentPatch.STREAM_CODEC, o -> o.components, (StreamCodec)ByteBufCodecs.VAR_INT, o -> o.minCount, (StreamCodec)ByteBufCodecs.VAR_INT, o -> o.maxCount, (StreamCodec)ByteBufCodecs.BOOL, o -> o.required, VariableCountItemResult::new);
    private final Holder<Item> holder;
    private final DataComponentPatch components;
    private final int minCount;
    private final int maxCount;
    private final boolean required;
    private ItemStack maximumResult;
    private ItemStack guiPreviewResult;

    private static DataResult<VariableCountItemResult> validate(VariableCountItemResult value) {
        if (value.maxCount > value.minCount) {
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> String.format("Variable item result max count (%s) must be higher than min count (%s).", value.maxCount, value.minCount));
    }

    public VariableCountItemResult(Holder<Item> holder, DataComponentPatch components, int minCount, int maxCount, boolean required) {
        this.holder = holder;
        this.components = components;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.required = required;
    }

    public VariableCountItemResult(ItemLike itemLike, DataComponentPatch components, int minCount, int maxCount, boolean required) {
        this((Holder<Item>)itemLike.asItem().builtInRegistryHolder(), components, minCount, maxCount, required);
    }

    public VariableCountItemResult(ItemStack stack, int minCount, int maxCount, boolean required) {
        this((Holder<Item>)stack.getItemHolder(), stack.getComponentsPatch(), minCount, maxCount, required);
    }

    @Override
    public boolean requiredOutput() {
        return this.required;
    }

    @Override
    public Item getItem() {
        return (Item)this.holder.value();
    }

    @Override
    public ItemStack getMaximumResult() {
        if (this.maximumResult == null) {
            this.maximumResult = this.create(this.maxCount);
        }
        return this.maximumResult;
    }

    @Override
    public ItemStack generateResult(RandomSource random) {
        int count = random.nextIntBetweenInclusive(this.minCount, this.maxCount);
        return this.create(count);
    }

    @Override
    public ItemResultType getType() {
        return ItemResultType.VARIABLE_COUNT;
    }

    @Override
    public ItemStack getGuiPreviewResult() {
        if (this.guiPreviewResult == null) {
            this.guiPreviewResult = this.create(1);
        }
        return this.guiPreviewResult;
    }

    @Override
    public int minimumCount() {
        return this.minCount;
    }

    @Override
    public int maximumCount() {
        return this.maxCount;
    }

    private ItemStack create(int count) {
        return new ItemStack(this.holder, count, this.components);
    }
}

