/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.registry;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredBlock;

public class DeferredBlockWithItem<B extends Block, I extends BlockItem>
extends DeferredBlock<B> {
    private final ResourceKey<Item> itemKey;
    @Nullable
    private Holder<Item> itemHolder;

    public static <B extends Block, I extends BlockItem> DeferredBlockWithItem<B, I> createBlockAndItemPair(ResourceLocation id) {
        return new DeferredBlockWithItem<B, I>((ResourceKey<Block>)ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id), (ResourceKey<Item>)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id));
    }

    public static <B extends Block, I extends BlockItem> DeferredBlockWithItem<B, I> createBlockAndItemPair(ResourceKey<Block> blockKey, ResourceKey<Item> itemKey) {
        return new DeferredBlockWithItem<B, I>(blockKey, itemKey);
    }

    private DeferredBlockWithItem(ResourceKey<Block> blockKey, ResourceKey<Item> itemKey) {
        super(blockKey);
        this.itemKey = itemKey;
    }

    public Holder<Item> getItemHolder() {
        this.bindItem();
        return Objects.requireNonNull(this.itemHolder, "Block '" + String.valueOf(this.getId()) + "' does not have a block item registered.");
    }

    public I asItem() {
        return (I)((BlockItem)this.getItemHolder().value());
    }

    void bindBlock() {
        this.bind(false);
    }

    void bindItem() {
        if (this.itemHolder == null) {
            this.itemHolder = BuiltInRegistries.ITEM.getHolder(this.itemKey).orElse(null);
        }
    }
}

