/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import liedge.limacore.registry.DeferredBlockWithItem;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import oshi.util.tuples.Pair;

public class LimaDeferredBlocksWithItems
extends DeferredRegister.Blocks {
    private final Map<DeferredBlockWithItem<?, ?>, Pair<Supplier<? extends Block>, Supplier<? extends BlockItem>>> pairEntries = new LinkedHashMap();
    private final Map<ResourceLocation, ResourceLocation> itemAliases = new Object2ObjectOpenHashMap();
    private boolean seenRegisterEvent;

    public static LimaDeferredBlocksWithItems create(String namespace) {
        return new LimaDeferredBlocksWithItems(namespace);
    }

    private LimaDeferredBlocksWithItems(String namespace) {
        super(namespace);
    }

    public void register(IEventBus bus) {
        super.register(bus);
        bus.addListener(this::registerPairEntries);
    }

    public Collection<DeferredHolder<Block, ? extends Block>> getEntries() {
        ObjectArrayList entries = new ObjectArrayList();
        entries.addAll(super.getEntries());
        entries.addAll(this.pairEntries.keySet());
        return ObjectLists.unmodifiable((ObjectList)entries);
    }

    public void addBlockAndItemAlias(ResourceLocation from, ResourceLocation to) {
        this.addAlias(from, to);
        this.itemAliases.put(from, to);
    }

    public Collection<DeferredHolder<Block, ? extends Block>> getEntriesWithItemsOnly() {
        return List.copyOf(this.pairEntries.keySet());
    }

    public <B extends Block, I extends BlockItem> DeferredBlockWithItem<B, I> registerBlockAndItem(String name, Function<ResourceLocation, ? extends B> blockFunction, BiFunction<ResourceLocation, ? super B, ? extends I> itemFunction) {
        return this.registerInternal(name, blockFunction, itemFunction);
    }

    public <B extends Block, I extends BlockItem> DeferredBlockWithItem<B, I> registerBlockAndItem(String name, Supplier<? extends B> blockSupplier, Function<? super B, ? extends I> itemFunction) {
        return this.registerBlockAndItem(name, (ResourceLocation key) -> (Block)blockSupplier.get(), (ResourceLocation key, ? super B block) -> (BlockItem)itemFunction.apply((Object)block));
    }

    public <B extends Block> DeferredBlockWithItem<B, BlockItem> registerBlockAndSimpleItem(String name, Function<ResourceLocation, ? extends B> blockFunction, Item.Properties itemProperties) {
        return this.registerBlockAndItem(name, blockFunction, (ResourceLocation key, ? super B block) -> new BlockItem(block, itemProperties));
    }

    public <B extends Block> DeferredBlockWithItem<B, BlockItem> registerBlockAndSimpleItem(String name, Function<ResourceLocation, ? extends B> blockFunction) {
        return this.registerBlockAndSimpleItem(name, blockFunction, new Item.Properties());
    }

    public <B extends Block> DeferredBlockWithItem<B, BlockItem> registerBlockAndSimpleItem(String name, Supplier<? extends B> blockSupplier, Item.Properties itemProperties) {
        return this.registerBlockAndSimpleItem(name, (ResourceLocation key) -> (Block)blockSupplier.get(), itemProperties);
    }

    public <B extends Block> DeferredBlockWithItem<B, BlockItem> registerBlockAndSimpleItem(String name, Supplier<? extends B> blockSupplier) {
        return this.registerBlockAndSimpleItem(name, blockSupplier, new Item.Properties());
    }

    public DeferredBlockWithItem<Block, BlockItem> registerSimpleBlockAndItem(String name, BlockBehaviour.Properties blockProperties, Item.Properties itemProperties) {
        return this.registerBlockAndSimpleItem(name, () -> new Block(blockProperties), itemProperties);
    }

    public DeferredBlockWithItem<Block, BlockItem> registerSimpleBlockAndItem(String name, BlockBehaviour.Properties blockProperties) {
        return this.registerSimpleBlockAndItem(name, blockProperties, new Item.Properties());
    }

    private <B extends Block, I extends BlockItem> DeferredBlockWithItem<B, I> registerInternal(String name, Function<ResourceLocation, ? extends B> blockFunction, BiFunction<ResourceLocation, ? super B, ? extends I> itemFunction) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot add new entries to block deferred register after RegisterEvent has been fired.");
        }
        Objects.requireNonNull(blockFunction);
        Objects.requireNonNull(itemFunction);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.getNamespace(), (String)Objects.requireNonNull(name));
        DeferredBlockWithItem holder = DeferredBlockWithItem.createBlockAndItemPair(id);
        Supplier<Block> blockSupplier = () -> (Block)blockFunction.apply(id);
        Supplier<BlockItem> itemSupplier = () -> (BlockItem)itemFunction.apply(id, (Object)holder.get());
        Pair pair = new Pair(blockSupplier, itemSupplier);
        if (this.pairEntries.putIfAbsent(holder, (Pair<Supplier<? extends Block>, Supplier<? extends BlockItem>>)pair) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return holder;
    }

    private void registerPairEntries(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.BLOCK) {
            this.seenRegisterEvent = true;
            this.pairEntries.forEach((holder, pair) -> {
                event.register(Registries.BLOCK, holder.getId(), () -> (Block)((Supplier)pair.getA()).get());
                holder.bindBlock();
            });
        } else if (event.getRegistryKey() == Registries.ITEM) {
            this.seenRegisterEvent = true;
            Registry registry = Objects.requireNonNull(event.getRegistry(Registries.ITEM), "Item registry missing. This should not happen.");
            this.itemAliases.forEach((arg_0, arg_1) -> ((Registry)registry).addAlias(arg_0, arg_1));
            this.pairEntries.forEach((holder, pair) -> {
                event.register(Registries.ITEM, holder.getId(), () -> (Item)((Supplier)pair.getB()).get());
                holder.bindItem();
            });
        }
    }
}

