/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.util.LimaCoreUtil;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class LimaBlockUtil {
    private static final double DEFAULT_CHUNK_TRACE_DISTANCE = 8.0;

    private LimaBlockUtil() {
    }

    private static IllegalArgumentException angleError(int angle) {
        return new IllegalArgumentException("Invalid rotation angle for shape: " + angle + ". Must be either 0 or an increment of 90 degrees.");
    }

    public static Direction getDirectionFacingPlayer(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            float xRot = player.getViewXRot(1.0f);
            float cos = Mth.cos((float)LimaCoreMath.toRad(xRot));
            if (cos > 0.7071f) {
                return context.getHorizontalDirection().getOpposite();
            }
            return xRot > 0.0f ? Direction.UP : Direction.DOWN;
        }
        return context.getClickedFace();
    }

    public static Stream<BlockPos> betweenClosedStreamSafe(Level level, AABB boundingBox) {
        return BlockPos.betweenClosedStream((AABB)boundingBox).filter(arg_0 -> ((Level)level).hasChunkAt(arg_0));
    }

    public static Stream<BlockPos> betweenClosedStreamSafeCeil(Level level, AABB boundingBox) {
        return BlockPos.betweenClosedStream((int)Mth.floor((double)boundingBox.minX), (int)Mth.floor((double)boundingBox.minY), (int)Mth.floor((double)boundingBox.minZ), (int)Mth.ceil((double)boundingBox.maxX), (int)Mth.ceil((double)boundingBox.maxY), (int)Mth.ceil((double)boundingBox.maxZ)).filter(arg_0 -> ((Level)level).hasChunkAt(arg_0));
    }

    @Nullable
    public static BlockEntity getSafeBlockEntity(@Nullable LevelReader level, BlockPos blockPos) {
        if (level != null && level.hasChunkAt(blockPos)) {
            return level.getBlockEntity(blockPos);
        }
        return null;
    }

    @Nullable
    public static <BE> BE getSafeBlockEntity(@Nullable LevelReader level, BlockPos blockPos, Class<BE> beClass) {
        return LimaCoreUtil.castOrNull(beClass, LimaBlockUtil.getSafeBlockEntity(level, blockPos));
    }

    @Nullable
    public static <BE> BE getBlockEntity(@Nullable BlockGetter level, BlockPos pos, Class<BE> beClass) {
        return level != null ? (BE)LimaCoreUtil.castOrNull(beClass, level.getBlockEntity(pos)) : null;
    }

    @Nullable
    public static LevelChunk getSafeLevelChunk(@Nullable LevelReader level, int chunkX, int chunkZ) {
        if (level != null && level.hasChunk(chunkX, chunkZ)) {
            return LimaCoreUtil.castOrNull(LevelChunk.class, level.getChunk(chunkX, chunkZ));
        }
        return null;
    }

    @Nullable
    public static LevelChunk getSafeLevelChunk(@Nullable LevelReader level, ChunkPos chunkPos) {
        return LimaBlockUtil.getSafeLevelChunk(level, chunkPos.x, chunkPos.z);
    }

    public static boolean hasChunkAt(LevelAccessor level, Position point) {
        int chunkX = SectionPos.blockToSectionCoord((double)point.x());
        int chunkZ = SectionPos.blockToSectionCoord((double)point.z());
        return level.hasChunk(chunkX, chunkZ);
    }

    public static Vec3 traceLoadedChunks(LevelAccessor level, Vec3 origin, Vec3 path, double stepDistance) {
        Vec3 lastValid;
        Vec3 end = origin.add(path);
        double length = origin.distanceTo(end);
        path = path.normalize().scale(stepDistance);
        Vec3 current = lastValid = origin;
        boolean interrupted = false;
        int maxSteps = (int)(length / stepDistance);
        for (int i = 0; i <= maxSteps; ++i) {
            if (!LimaBlockUtil.hasChunkAt(level, (Position)current)) {
                interrupted = true;
                break;
            }
            lastValid = current;
            current = current.add(path);
        }
        return interrupted ? lastValid : end;
    }

    public static Vec3 traceLoadedChunks(LevelAccessor level, Vec3 origin, Vec3 path) {
        return LimaBlockUtil.traceLoadedChunks(level, origin, path, 8.0);
    }

    public static VoxelShape dimensionBox(double x, double y, double z, double xSize, double ySize, double zSize) {
        return Block.box((double)x, (double)y, (double)z, (double)(x + xSize), (double)(y + ySize), (double)(z + zSize));
    }

    public static int rotationYFromDirection(Direction side) {
        Preconditions.checkArgument((boolean)side.getAxis().isHorizontal(), (Object)"Direction must be horizontal for Y axis rotation angle.");
        return (int)(side.toYRot() + 180.0f) % 360;
    }

    public static List<AABB> blockPosShiftedAABBs(VoxelShape shape, BlockPos pos) {
        ObjectArrayList list = new ObjectArrayList();
        shape.forAllBoxes((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> LimaBlockUtil.lambda$blockPosShiftedAABBs$0((List)list, pos, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
        return list;
    }

    public static VoxelShape modifyAndMergeAllBoxes(VoxelShape original, VoxelShapeFactory factory) {
        Stream.Builder builder = Stream.builder();
        original.forAllBoxes((x1, y1, z1, x2, y2, z2) -> builder.add(factory.createShape(x1, y1, z1, x2, y2, z2)));
        return builder.build().reduce(Shapes.empty(), Shapes::or);
    }

    public static VoxelShape moveShape(VoxelShape original, double dx, double dy, double dz) {
        return LimaBlockUtil.modifyAndMergeAllBoxes(original, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)(x1 + dx), (double)(y1 + dy), (double)(z1 + dz), (double)(x2 + dx), (double)(y2 + dy), (double)(z2 + dz)));
    }

    public static Map<Direction, VoxelShape> createHorizontalShapeMap(VoxelShape identity) {
        return Direction.Plane.HORIZONTAL.stream().collect(LimaStreamsUtil.toUnmodifiableEnumMap(Direction.class, side -> LimaBlockUtil.rotateYClockwise(identity, LimaBlockUtil.rotationYFromDirection(side))));
    }

    public static VoxelShape rotateXClockwise(VoxelShape shape, int angle) {
        int fixedAngle = angle % 360;
        return switch (fixedAngle) {
            case 0 -> shape;
            case 90 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)(1.0 - y2), (double)x1, (double)z1, (double)(1.0 - y1), (double)x2, (double)z2));
            case 180 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)(1.0 - x2), (double)(1.0 - y2), (double)z1, (double)(1.0 - x1), (double)(1.0 - y1), (double)z2));
            case 270 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)y1, (double)(1.0 - x2), (double)z1, (double)y2, (double)(1.0 - x1), (double)z2));
            default -> throw LimaBlockUtil.angleError(fixedAngle);
        };
    }

    public static VoxelShape rotateYClockwise(VoxelShape shape, int angle) {
        int fixedAngle = angle % 360;
        return switch (fixedAngle) {
            case 0 -> shape;
            case 90 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)(1.0 - z2), (double)y1, (double)x1, (double)(1.0 - z1), (double)y2, (double)x2));
            case 180 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)(1.0 - x2), (double)y1, (double)(1.0 - z2), (double)(1.0 - x1), (double)y2, (double)(1.0 - z1)));
            case 270 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)z1, (double)y1, (double)(1.0 - x2), (double)z2, (double)y2, (double)(1.0 - x1)));
            default -> throw LimaBlockUtil.angleError(fixedAngle);
        };
    }

    public static VoxelShape rotateZClockWise(VoxelShape shape, int angle) {
        int fixedAngle = angle % 360;
        return switch (fixedAngle) {
            case 0 -> shape;
            case 90 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)x1, (double)(1.0 - z2), (double)y1, (double)x2, (double)(1.0 - z1), (double)y2));
            case 180 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)x1, (double)(1.0 - y2), (double)(1.0 - z2), (double)x2, (double)(1.0 - y1), (double)(1.0 - z1)));
            case 270 -> LimaBlockUtil.modifyAndMergeAllBoxes(shape, (x1, y1, z1, x2, y2, z2) -> Shapes.box((double)x1, (double)z1, (double)(1.0 - y2), (double)x2, (double)z2, (double)(1.0 - y1)));
            default -> throw LimaBlockUtil.angleError(fixedAngle);
        };
    }

    private static /* synthetic */ void lambda$blockPosShiftedAABBs$0(List list, BlockPos pos, double x1, double y1, double z1, double x2, double y2, double z2) {
        list.add(new AABB(x1 + (double)pos.getX(), y1 + (double)pos.getY(), z1 + (double)pos.getZ(), x2 + (double)pos.getX(), y2 + (double)pos.getY(), z2 + (double)pos.getZ()));
    }

    @FunctionalInterface
    public static interface VoxelShapeFactory {
        public VoxelShape createShape(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

