/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public final class LimaCollectionsUtil {
    private LimaCollectionsUtil() {
    }

    public static <E, C extends Collection<E>> C mergeCollections(C first, Collection<E> second) {
        first.addAll(second);
        return first;
    }

    public static <K, V, M extends Map<K, V>> M mergeMapsNoDuplicates(M first, Map<K, V> second) {
        for (Map.Entry<K, V> entry : second.entrySet()) {
            LimaCollectionsUtil.putNoDuplicates(first, entry.getKey(), entry.getValue());
        }
        return first;
    }

    @Nullable
    public static <T> T getFrom(T[] array, int index) {
        return index >= 0 && index < array.length ? (T)array[index] : null;
    }

    @Nullable
    public static <T> T getFrom(List<T> list, int index) {
        return index >= 0 && index < list.size() ? (T)list.get(index) : null;
    }

    public static <T> int addAndGetIndex(List<T> list, T element) {
        int index = list.size();
        list.add(element);
        return index;
    }

    public static int[] shuffleIntArray(int[] array, RandomSource random) {
        for (int a = array.length - 1; a > 0; --a) {
            int b = random.nextInt(a + 1);
            IntArrays.swap((int[])array, (int)a, (int)b);
        }
        return array;
    }

    public static int[] shuffleIndices(List<?> list, RandomSource random) {
        int[] arr = new int[list.size()];
        Arrays.setAll(arr, IntUnaryOperator.identity());
        return LimaCollectionsUtil.shuffleIntArray(arr, random);
    }

    public static <T> List<T> shuffledList(List<T> source, RandomSource random) {
        int[] si;
        ObjectArrayList result = new ObjectArrayList();
        for (int i : si = LimaCollectionsUtil.shuffleIndices(source, random)) {
            result.add(source.get(i));
        }
        return result;
    }

    public static Stream<CompoundTag> streamCompoundList(ListTag tag) {
        if (tag.isEmpty()) {
            return Stream.empty();
        }
        Preconditions.checkArgument((tag.getElementType() == 10 ? 1 : 0) != 0, (Object)"NBT tag list is not a compound tag list");
        return tag.stream().map(t -> (CompoundTag)t);
    }

    public static IntList toIntList(IntStream stream) {
        return (IntList)LimaCollectionsUtil.toIntCollection(stream, IntArrayList::new);
    }

    public static IntSet toIntSet(IntStream stream) {
        return (IntSet)LimaCollectionsUtil.toIntCollection(stream, IntOpenHashSet::new);
    }

    public static <E extends Enum<E>> E[] checkedEnumConstants(Class<E> enumClass) {
        return Objects.requireNonNull((Enum[])enumClass.getEnumConstants(), "Enum constants not found");
    }

    public static <E extends Enum<E>> E getEnumByOrdinal(Class<E> enumClass, int ordinal) {
        Enum[] values = LimaCollectionsUtil.checkedEnumConstants(enumClass);
        Preconditions.checkElementIndex((int)ordinal, (int)values.length, (String)"Enum ordinal");
        return (E)values[ordinal];
    }

    public static <E extends Enum<E>, U> Map<E, U> fillAndCreateEnumMap(Class<E> enumClass, Function<E, ? extends U> mapper) {
        return LimaStreamsUtil.enumStream(enumClass).collect(LimaStreamsUtil.toEnumMap(enumClass, mapper));
    }

    public static <E extends Enum<E>, U> Map<E, U> fillAndCreateImmutableEnumMap(Class<E> enumClass, Function<E, ? extends U> mapper) {
        return LimaStreamsUtil.enumStream(enumClass).collect(LimaStreamsUtil.toUnmodifiableEnumMap(enumClass, mapper));
    }

    public static <K, V, X extends Throwable> void putNoDuplicates(Map<K, V> map, K key, V value, Supplier<X> exceptionSupplier) throws X {
        V added = map.putIfAbsent(key, value);
        if (added != null) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <K, V> void putNoDuplicates(Map<K, V> map, K key, V value) {
        LimaCollectionsUtil.putNoDuplicates(map, key, value, () -> new IllegalArgumentException("Duplicate map key '" + String.valueOf(key) + "'."));
    }

    public static int splitCollectionToSegments(Collection<?> collection, int segmentSize) {
        int size = collection.size();
        return size / segmentSize + (size % segmentSize == 0 ? 0 : 1);
    }

    private static <T extends IntCollection> T toIntCollection(IntStream stream, Supplier<T> supplier) {
        return (T)stream.collect(supplier, IntCollection::add, IntCollection::addAll);
    }
}

