/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import java.util.function.Predicate;
import liedge.limacore.lib.ModResources;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;

public final class LimaItemUtil {
    public static final Predicate<ItemStack> ALWAYS_TRUE = stack -> true;
    public static final Predicate<ItemStack> ALWAYS_FALSE = stack -> false;

    private LimaItemUtil() {
    }

    public static boolean areItemsMergeCompatible(ItemStack existing, ItemStack other) {
        return existing.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)other, (ItemStack)existing);
    }

    public static boolean canMergeItemStacks(ItemStack existing, ItemStack other, boolean allowPartialMerge) {
        if (LimaItemUtil.areItemsMergeCompatible(existing, other)) {
            int limit;
            if (existing.isEmpty()) {
                limit = other.getMaxStackSize();
            } else {
                limit = existing.getMaxStackSize();
                limit -= existing.getCount();
            }
            if (limit <= 0) {
                return false;
            }
            return allowPartialMerge || other.getCount() <= limit;
        }
        return false;
    }

    public static boolean canMergeItemStacks(ItemStack existing, ItemStack other) {
        return LimaItemUtil.canMergeItemStacks(existing, other, false);
    }

    public static <T> InteractionResultHolder<T> sidedFail(T stack, boolean isClientSide) {
        return isClientSide ? InteractionResultHolder.fail(stack) : InteractionResultHolder.consume(stack);
    }

    public static CreativeModeTab.Builder tabBuilderWithTitle(ResourceLocation id) {
        return CreativeModeTab.builder().title((Component)Component.translatable((String)ModResources.prefixedIdLangKey("creative_tab", id)));
    }

    public static boolean hasValidCapability(ItemCapability<?, Void> capability, ItemStack stack) {
        return stack.getCapability(capability) != null;
    }

    public static boolean hasEnergyCapability(ItemStack stack) {
        return LimaItemUtil.hasValidCapability(Capabilities.EnergyStorage.ITEM, stack);
    }

    public static boolean hasItemHandlerCapability(ItemStack stack) {
        return LimaItemUtil.hasValidCapability(Capabilities.ItemHandler.ITEM, stack);
    }

    public static boolean hasFluidHandlerCapability(ItemStack stack) {
        return LimaItemUtil.hasValidCapability(Capabilities.FluidHandler.ITEM, stack);
    }
}

