/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.util.LimaCollectionsUtil;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class LimaNbtUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final IntSet NUMERIC_TYPES = IntSet.of((int[])new int[]{1, 6, 5, 3, 4, 2});

    private LimaNbtUtil() {
    }

    public static <T> void tryEncodeTo(Codec<T> codec, DynamicOps<Tag> ops, @Nullable T value, CompoundTag compoundTag, String key) {
        if (value != null) {
            LimaCoreCodecs.tryEncodeTo(codec, ops, value, tag -> compoundTag.put(key, tag));
        }
    }

    public static <T> T strictDecode(Codec<T> codec, DynamicOps<Tag> ops, CompoundTag compoundTag, String key) {
        Tag tag = Objects.requireNonNull(compoundTag.get(key), "Child tag '" + key + "' not found in compound tag.");
        return LimaCoreCodecs.strictDecode(codec, ops, tag);
    }

    @Nullable
    public static <T> T tryDecode(Codec<T> codec, DynamicOps<Tag> ops, CompoundTag compoundTag, String key) {
        Tag tag = compoundTag.get(key);
        return tag != null ? (T)LimaCoreCodecs.tryDecode(codec, ops, tag) : null;
    }

    public static <T> T tryDecode(Codec<T> codec, DynamicOps<Tag> ops, CompoundTag compoundTag, String key, T fallback) {
        Tag tag = compoundTag.get(key);
        if (tag == null) {
            return fallback;
        }
        return LimaCoreCodecs.tryDecode(codec, ops, tag, fallback);
    }

    @Nullable
    public static <T> T tryFlatDecode(Codec<Optional<T>> codec, DynamicOps<Tag> ops, CompoundTag compoundTag, String key) {
        Tag tag = compoundTag.get(key);
        return tag != null ? (T)LimaCoreCodecs.tryFlatDecode(codec, ops, tag) : null;
    }

    public static <T> T tryFlatDecode(Codec<Optional<T>> codec, DynamicOps<Tag> ops, CompoundTag compoundTag, String key, T fallback) {
        Tag tag = compoundTag.get(key);
        if (tag == null) {
            return fallback;
        }
        return LimaCoreCodecs.tryFlatDecode(codec, ops, tag, fallback);
    }

    public static boolean getAsBoolean(CompoundTag tag, String key, boolean fallback) {
        return tag.contains(key, 1) ? tag.getBoolean(key) : fallback;
    }

    public static int getAsInt(CompoundTag tag, String key, int fallback) {
        return tag.contains(key, 3) ? tag.getInt(key) : fallback;
    }

    public static float getAsFloat(CompoundTag tag, String key, float fallback) {
        return tag.contains(key, 5) ? tag.getFloat(key) : fallback;
    }

    public static double getAsDouble(CompoundTag tag, String key, double fallback) {
        return tag.contains(key, 6) ? tag.getDouble(key) : fallback;
    }

    public static ResourceLocation getAsResourceLocation(CompoundTag tag, String key) {
        if (tag.contains(key, 8)) {
            return ResourceLocation.parse((String)tag.getString(key));
        }
        throw new IllegalArgumentException("'" + key + "' is not a String value in compound tag");
    }

    public static <E extends Enum<E>> E getAsEnum(CompoundTag tag, String key, Class<E> enumClass) {
        Enum[] enumValues = LimaCollectionsUtil.checkedEnumConstants(enumClass);
        int ordinal = LimaNbtUtil.getAsInt(tag, key, -1);
        Preconditions.checkElementIndex((int)ordinal, (int)enumValues.length, (String)"Enum ordinal");
        return (E)enumValues[ordinal];
    }

    public static <E extends Enum<E>> E getAsEnum(CompoundTag tag, String key, Class<E> enumClass, E fallback) {
        Enum[] enumValues = LimaCollectionsUtil.checkedEnumConstants(enumClass);
        int ordinal = LimaNbtUtil.getAsInt(tag, key, -1);
        return (E)(ordinal >= 0 && ordinal < enumValues.length ? enumValues[ordinal] : fallback);
    }

    private static <T extends Tag> void deserializeUnchecked(INBTSerializable<T> serializable, HolderLookup.Provider registries, byte tagType, @Nullable Tag rawTag) {
        if (rawTag == null || rawTag.getId() != tagType) {
            throw new IllegalArgumentException("Null or mismatching tag type");
        }
        serializable.deserializeNBT(registries, rawTag);
    }

    public static void deserializeInt(INBTSerializable<IntTag> serializable, HolderLookup.Provider registries, @Nullable Tag rawTag) {
        LimaNbtUtil.deserializeUnchecked(serializable, registries, (byte)3, rawTag);
    }

    public static void deserializeString(INBTSerializable<StringTag> serializable, HolderLookup.Provider registries, @Nullable Tag rawTag) {
        LimaNbtUtil.deserializeUnchecked(serializable, registries, (byte)8, rawTag);
    }

    public static void deserializeList(INBTSerializable<ListTag> serializable, HolderLookup.Provider registries, @Nullable Tag rawTag) {
        LimaNbtUtil.deserializeUnchecked(serializable, registries, (byte)9, rawTag);
    }

    @Nullable
    public static UUID getOptionalUUID(CompoundTag tag, String key) {
        return tag.contains(key, 11) ? tag.getUUID(key) : null;
    }

    public static void putOptionalUUID(CompoundTag tag, String key, @Nullable UUID uuid) {
        if (uuid != null) {
            tag.putUUID(key, uuid);
        }
    }

    @Nullable
    public static ResourceLocation getOptionalResourceLocation(CompoundTag tag, String key) {
        return tag.contains(key, 8) ? ResourceLocation.parse((String)tag.getString(key)) : null;
    }

    public static void putOptionalResourceLocation(CompoundTag tag, String key, @Nullable ResourceLocation resourceLocation) {
        if (resourceLocation != null) {
            tag.putString(key, resourceLocation.toString());
        }
    }

    public static CompletableFuture<?> saveCompressedNbt(CachedOutput cache, CompoundTag tag, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                HashingOutputStream hashStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteStream);
                NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)hashStream);
                hashStream.close();
                cache.writeIfNeeded(path, byteStream.toByteArray(), hashStream.hash());
            }
            catch (IOException ex) {
                DataProvider.LOGGER.error("Failed to save file to {}", (Object)path, (Object)ex);
            }
        }, Util.backgroundExecutor());
    }
}

