/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public final class LimaRecipesUtil {
    private LimaRecipesUtil() {
    }

    public static <T extends Recipe<?>> Optional<RecipeHolder<T>> getRecipeById(Level level, ResourceLocation recipeId, RecipeType<T> recipeType) {
        return level.getRecipeManager().byKey(recipeId).filter(holder -> holder.value().getType().equals((Object)recipeType)).map(h -> h);
    }

    public static <T extends Recipe<?>> Optional<RecipeHolder<T>> getRecipeById(Level level, ResourceLocation recipeId, Supplier<? extends RecipeType<T>> typeSupplier) {
        return LimaRecipesUtil.getRecipeById(level, recipeId, typeSupplier.get());
    }

    public static <T extends RecipeInput, R extends Recipe<T>> List<RecipeHolder<R>> getSortedRecipesForType(Level level, RecipeType<R> recipeType, Comparator<RecipeHolder<R>> comparator) {
        return (List)level.getRecipeManager().getAllRecipesFor(recipeType).stream().sorted(comparator).collect(LimaStreamsUtil.toUnmodifiableObjectList());
    }

    public static <T extends RecipeInput, R extends Recipe<T>> List<RecipeHolder<R>> getSortedRecipesForType(Level level, RecipeType<R> recipeType, Comparator<RecipeHolder<R>> primary, Comparator<RecipeHolder<R>> secondary) {
        return LimaRecipesUtil.getSortedRecipesForType(level, recipeType, primary.thenComparing(secondary));
    }

    public static <T extends RecipeInput, R extends Recipe<T>> List<RecipeHolder<R>> getSortedRecipesForType(Level level, Supplier<? extends RecipeType<R>> typeSupplier, Comparator<RecipeHolder<R>> comparator) {
        return LimaRecipesUtil.getSortedRecipesForType(level, typeSupplier.get(), comparator);
    }

    public static <T extends RecipeInput, R extends Recipe<T>> List<RecipeHolder<R>> getSortedRecipesForType(Level level, Supplier<? extends RecipeType<R>> typeSupplier, Comparator<RecipeHolder<R>> primary, Comparator<RecipeHolder<R>> secondary) {
        return LimaRecipesUtil.getSortedRecipesForType(level, typeSupplier.get(), primary, secondary);
    }
}

