/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.holdersets.OrHolderSet;

public final class LimaRegistryUtil {
    private LimaRegistryUtil() {
    }

    public static <T> Stream<Map.Entry<ResourceKey<T>, T>> allNamespaceRegistryEntries(String modid, Registry<T> registry) {
        return registry.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals(modid));
    }

    public static <T> Stream<T> allNamespaceRegistryValues(String modid, Registry<T> registry) {
        return LimaRegistryUtil.allNamespaceRegistryEntries(modid, registry).map(Map.Entry::getValue);
    }

    public static <T> ResourceKey<T> getNonNullResourceKey(T object, Registry<T> registry) {
        return (ResourceKey)registry.getResourceKey(object).orElseThrow(() -> new NullPointerException("Object is not present in registry."));
    }

    public static <T> ResourceKey<T> getNonNullResourceKey(Holder<T> holder) {
        return (ResourceKey)holder.unwrapKey().orElseThrow(() -> new RuntimeException("Holder is missing resource key."));
    }

    public static <T> ResourceLocation getNonNullRegistryId(T object, Registry<T> registry) {
        DefaultedRegistry defaultedRegistry;
        ResourceLocation id = registry.getKey(object);
        if (id == null || registry instanceof DefaultedRegistry && (defaultedRegistry = (DefaultedRegistry)registry).getDefaultKey().equals((Object)id)) {
            throw new NullPointerException("Object is not present in registry.");
        }
        return id;
    }

    public static <T> ResourceLocation getNonNullRegistryId(Holder<T> holder) {
        return LimaRegistryUtil.getNonNullResourceKey(holder).location();
    }

    public static <T> T getNonNullRegistryValue(ResourceLocation id, Registry<T> registry) {
        return (T)Objects.requireNonNull(registry.get(id), () -> String.format("No value matching id '%s' found in registry [%s]", id, registry.key().location()));
    }

    public static <T> T getNonNullRegistryValue(ResourceKey<T> resourceKey, Registry<T> registry) {
        return (T)Objects.requireNonNull(registry.get(resourceKey), () -> String.format("No value matching resource key '%s' found in registry [%s]", resourceKey.location(), registry.key().location()));
    }

    public static <T> Holder<T> getNonNullHolder(ResourceLocation id, Registry<T> registry) {
        return (Holder)registry.getHolder(id).orElseThrow(() -> new NullPointerException(String.format("Missing holder for id '%s' in registry [%s]", id, registry.key().location())));
    }

    public static <T> Holder<T> getNonNullHolder(ResourceKey<T> resourceKey, Registry<T> registry) {
        return (Holder)registry.getHolder(resourceKey).orElseThrow(() -> new NullPointerException(String.format("Missing holder for resource key '%s' in registry [%s]", resourceKey.location(), registry.key().location())));
    }

    public static <T> Holder<T> getNonNullReferenceHolder(RegistryAccess registryAccess, ResourceKey<? extends Registry<T>> registryKey, ResourceLocation id) {
        return (Holder)registryAccess.registryOrThrow(registryKey).getHolder(id).orElseThrow(() -> new NullPointerException(String.format("Missing holder id '%s' in registry access for '%s'", id, registryKey.location())));
    }

    public static ResourceLocation getItemId(Item item) {
        return LimaRegistryUtil.getNonNullRegistryId(item, BuiltInRegistries.ITEM);
    }

    public static ResourceLocation getBlockId(Block block) {
        return LimaRegistryUtil.getNonNullRegistryId(block, BuiltInRegistries.BLOCK);
    }

    public static String getItemName(Item item) {
        return LimaRegistryUtil.getItemId(item).getPath();
    }

    public static String getItemName(ItemStack stack) {
        return LimaRegistryUtil.getItemName(stack.getItem());
    }

    public static String getItemName(Holder<Item> holder) {
        return LimaRegistryUtil.getNonNullRegistryId(holder).getPath();
    }

    public static String getBlockName(Block block) {
        return LimaRegistryUtil.getBlockId(block).getPath();
    }

    public static String getBlockName(Holder<Block> holder) {
        return LimaRegistryUtil.getNonNullRegistryId(holder).getPath();
    }

    public static String getFluidName(FluidStack fluid) {
        return LimaRegistryUtil.getFluidName((Holder<Fluid>)fluid.getFluidHolder());
    }

    public static String getFluidName(Fluid fluid) {
        return LimaRegistryUtil.getNonNullRegistryId(fluid, BuiltInRegistries.FLUID).getPath();
    }

    public static String getFluidName(Holder<Fluid> holder) {
        return LimaRegistryUtil.getNonNullRegistryId(holder).getPath();
    }

    public static <T> HolderSet<T> keyHolderSet(HolderGetter<T> holderGetter, ResourceKey<T> key) {
        return HolderSet.direct((Holder[])new Holder[]{holderGetter.getOrThrow(key)});
    }

    @SafeVarargs
    public static <T> HolderSet<T> keyHolderSet(HolderGetter<T> holderGetter, ResourceKey<T> ... keys) {
        return HolderSet.direct(arg_0 -> holderGetter.getOrThrow(arg_0), (Object[])keys);
    }

    public static <T> HolderSet<T> mergeHolderSets(List<HolderSet<T>> holderSets) {
        return switch (holderSets.size()) {
            case 0 -> HolderSet.empty();
            case 1 -> holderSets.getFirst();
            default -> new OrHolderSet(holderSets);
        };
    }
}

