/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.generation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import liedge.limacore.LimaCore;
import liedge.limacore.registry.game.LimaCoreWorldGen;
import liedge.limacore.util.LimaCollectionsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.jetbrains.annotations.Nullable;

public final class PlaceOnSideFeature
extends Feature<Configuration> {
    public static ConfiguredFeature<Configuration, PlaceOnSideFeature> placeOnSide(BlockStateProvider toPlace, Direction side) {
        return new ConfiguredFeature((Feature)((PlaceOnSideFeature)((Object)LimaCoreWorldGen.PLACE_ON_SIDE_FEATURE.get())), (FeatureConfiguration)new Configuration(toPlace, BlockStateProperties.FACING, List.of(side)));
    }

    public static ConfiguredFeature<Configuration, PlaceOnSideFeature> placeOnSides(BlockStateProvider toPlace, Direction ... sides) {
        return new ConfiguredFeature((Feature)((PlaceOnSideFeature)((Object)LimaCoreWorldGen.PLACE_ON_SIDE_FEATURE.get())), (FeatureConfiguration)new Configuration(toPlace, BlockStateProperties.FACING, List.of(sides)));
    }

    public static ConfiguredFeature<Configuration, PlaceOnSideFeature> placeOnAnySide(BlockStateProvider toPlace) {
        return PlaceOnSideFeature.placeOnSides(toPlace, Direction.values());
    }

    public static ConfiguredFeature<Configuration, PlaceOnSideFeature> placeOnAnyHorizontalSide(BlockStateProvider toPlace) {
        return PlaceOnSideFeature.placeOnSides(toPlace, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    }

    public PlaceOnSideFeature() {
        super(Configuration.CODEC);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        Configuration config = (Configuration)context.config();
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        BlockState toPlace = config.toPlace.getState(context.random(), origin);
        DirectionProperty facingProperty = PlaceOnSideFeature.findProperty(toPlace, config.facingProperty);
        if (facingProperty == null) {
            return false;
        }
        List<Direction> facesToCheck = LimaCollectionsUtil.shuffledList(config.validFaces, context.random());
        for (Direction side : facesToCheck) {
            if (!facingProperty.getPossibleValues().contains(side)) {
                LimaCore.LOGGER.warn("Feature configuration contains a target face not valid for block state: {}", (Object)toPlace);
                continue;
            }
            BlockState orientedToPlace = (BlockState)toPlace.setValue((Property)facingProperty, (Comparable)side);
            BlockPos toPlacePos = origin.relative(side);
            if (!level.getBlockState(toPlacePos).canBeReplaced() || !orientedToPlace.canSurvive((LevelReader)level, toPlacePos)) continue;
            level.setBlock(toPlacePos, orientedToPlace, 2);
            return true;
        }
        return false;
    }

    @Nullable
    private static DirectionProperty findProperty(BlockState state, String propertyName) {
        return state.getProperties().stream().filter(p -> p.getName().equals(propertyName)).filter(p -> p instanceof DirectionProperty).map(p -> (DirectionProperty)p).findAny().orElse(null);
    }

    public record Configuration(BlockStateProvider toPlace, String facingProperty, List<Direction> validFaces) implements FeatureConfiguration
    {
        private static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("to_place").forGetter(Configuration::toPlace), (App)Codec.STRING.fieldOf("facing_property").forGetter(Configuration::facingProperty), (App)Direction.CODEC.listOf(1, 6).fieldOf("valid_faces").forGetter(Configuration::validFaces)).apply((Applicative)instance, Configuration::new));

        public Configuration(BlockStateProvider toPlace, DirectionProperty property, List<Direction> validFaces) {
            this(toPlace, property.getName(), validFaces);
        }
    }
}

