/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.generation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import liedge.limacore.registry.game.LimaCoreWorldGen;
import liedge.limacore.util.LimaCollectionsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public final class RandomAxisScanPlacement
extends PlacementModifier {
    public static final MapCodec<RandomAxisScanPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Direction.Axis.CODEC.fieldOf("search_axis").forGetter(o -> o.searchAxis), (App)Codec.intRange((int)0, (int)16).fieldOf("radius").forGetter(o -> o.radius), (App)BlockPredicate.CODEC.fieldOf("target_condition").forGetter(o -> o.targetCondition)).apply((Applicative)instance, RandomAxisScanPlacement::new));
    private final Direction.Axis searchAxis;
    private final int radius;
    private final BlockPredicate targetCondition;

    public static RandomAxisScanPlacement vertical(int radius, BlockPredicate targetCondition) {
        return new RandomAxisScanPlacement(Direction.Axis.Y, radius, targetCondition);
    }

    public static RandomAxisScanPlacement xAxis(int radius, BlockPredicate targetCondition) {
        return new RandomAxisScanPlacement(Direction.Axis.X, radius, targetCondition);
    }

    public static RandomAxisScanPlacement zAxis(int radius, BlockPredicate targetCondition) {
        return new RandomAxisScanPlacement(Direction.Axis.Z, radius, targetCondition);
    }

    public RandomAxisScanPlacement(Direction.Axis searchAxis, int radius, BlockPredicate targetCondition) {
        this.searchAxis = searchAxis;
        this.radius = radius;
        this.targetCondition = targetCondition;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos origin) {
        WorldGenLevel level = context.getLevel();
        int originN = this.searchAxis.choose(origin.getX(), origin.getY(), origin.getZ());
        IntStream oStream = IntStream.rangeClosed(originN - this.radius, originN + this.radius).filter(i -> !this.searchAxis.isVertical() || !level.isOutsideBuildHeight(i));
        int[] oArray = LimaCollectionsUtil.shuffleIntArray(oStream.toArray(), random);
        BlockPos.MutableBlockPos cursor = origin.mutable();
        for (int o : oArray) {
            switch (this.searchAxis) {
                case X: {
                    cursor.setX(o);
                    break;
                }
                case Y: {
                    cursor.setY(o);
                    break;
                }
                case Z: {
                    cursor.setZ(o);
                }
            }
            if (!this.targetCondition.test((Object)level, (Object)cursor)) continue;
            return Stream.of(cursor.immutable());
        }
        return Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)LimaCoreWorldGen.RANDOM_AXIS_SCAN_PLACEMENT.get();
    }
}

