/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public final class DynamicWeightLootEntry
extends LootPoolEntryContainer {
    public static final MapCodec<DynamicWeightLootEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("dynamic_weight").forGetter(o -> o.dynamicWeight), (App)Codec.BOOL.optionalFieldOf("replace_weight", (Object)true).forGetter(o -> o.replaceWeight), (App)LootPoolEntries.CODEC.fieldOf("child").forGetter(o -> o.child)).and(DynamicWeightLootEntry.commonFields((RecordCodecBuilder.Instance)instance).t1()).apply((Applicative)instance, DynamicWeightLootEntry::new));
    private final NumberProvider dynamicWeight;
    private final boolean replaceWeight;
    private final LootPoolEntryContainer child;

    public static Builder dynamicWeight(LootPoolEntryContainer.Builder<?> childBuilder) {
        return new Builder(childBuilder.build());
    }

    public static Builder dynamicWeightItem(ItemLike item) {
        return DynamicWeightLootEntry.dynamicWeight(LootItem.lootTableItem((ItemLike)item));
    }

    public static Builder dynamicWeightItem(ItemLike item, int baseWeight) {
        return DynamicWeightLootEntry.dynamicWeight(LootItem.lootTableItem((ItemLike)item).setWeight(baseWeight));
    }

    private DynamicWeightLootEntry(NumberProvider dynamicWeight, boolean replaceWeight, LootPoolEntryContainer child, List<LootItemCondition> conditions) {
        super(conditions);
        this.dynamicWeight = dynamicWeight;
        this.replaceWeight = replaceWeight;
        this.child = child;
    }

    public void validate(ValidationContext validationContext) {
        super.validate(validationContext);
        this.child.validate(validationContext.forChild(".child_entry"));
    }

    public LootPoolEntryType getType() {
        return (LootPoolEntryType)LimaCoreLootRegistries.DYNAMIC_WEIGHT_LOOT_ENTRY.get();
    }

    public boolean expand(LootContext ctx, Consumer<LootPoolEntry> entryConsumer) {
        if (this.canRun(ctx)) {
            final int dynamicWeight = this.dynamicWeight.getInt(ctx);
            return this.child.expand(ctx, original -> entryConsumer.accept(new LootPoolEntry(){
                final /* synthetic */ LootPoolEntry val$original;
                {
                    this.val$original = lootPoolEntry;
                }

                public int getWeight(float luck) {
                    return DynamicWeightLootEntry.this.replaceWeight ? dynamicWeight : this.val$original.getWeight(luck) + dynamicWeight;
                }

                public void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
                    this.val$original.createItemStack(stackConsumer, lootContext);
                }
            }));
        }
        return false;
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final LootPoolEntryContainer child;
        private NumberProvider dynamicWeight;
        private boolean replaceWeight = true;

        public Builder(LootPoolEntryContainer child) {
            this.child = child;
        }

        public Builder setReplaceWeight(boolean replaceWeight) {
            this.replaceWeight = replaceWeight;
            return this;
        }

        public Builder setDynamicWeight(NumberProvider dynamicWeight) {
            this.dynamicWeight = dynamicWeight;
            return this;
        }

        protected Builder getThis() {
            return this;
        }

        public LootPoolEntryContainer build() {
            Objects.requireNonNull(this.dynamicWeight, "Dynamic weight not set.");
            return new DynamicWeightLootEntry(this.dynamicWeight, this.replaceWeight, this.child, this.getConditions());
        }
    }
}

